package Dist::Zilla::Plugin::Readme 6.037;
# ABSTRACT: build a README file

use Moose;
with qw/Dist::Zilla::Role::FileGatherer
    Dist::Zilla::Role::TextTemplate
    Dist::Zilla::Role::FileMunger/;

use Dist::Zilla::Pragmas;

use Moose::Util::TypeConstraints;
use namespace::autoclean;

#pod =head1 DESCRIPTION
#pod
#pod This plugin adds a very simple F<README> file to the distribution, citing the
#pod dist's name, version, abstract, and license.  It may be more useful or
#pod informative in the future.
#pod
#pod =cut

has _file_obj => (
  is => 'rw', isa => role_type('Dist::Zilla::Role::File'),
);

sub gather_files {
  my ($self, $arg) = @_;

  require Dist::Zilla::File::InMemory;

  my $template = q|

This archive contains the distribution {{ $dist->name }},
version {{ $dist->version }}:

  {{ $dist->abstract }}

{{ $dist->license->notice }}

This README file was generated by {{ $generated_by }}.

|;
  $template =~ s/\A\n+//;
  $template =~ s/\n+\z/\n/;

  $self->add_file(
    $self->_file_obj(
      Dist::Zilla::File::InMemory->new(
        name => 'README',
        content => $template,
      )
    )
  );

  return;
}

sub munge_files {
  my $self = shift;

  my $file = $self->_file_obj;

  $file->content(
    $self->fill_in_string(
      $file->content,
      {
        dist => \($self->zilla),
        generated_by => \sprintf("%s v%s",
                          ref($self), $self->VERSION || '(dev)'),
      }
    )
  );

  return;
}

__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Readme - build a README file

=head1 VERSION

version 6.037

=head1 DESCRIPTION

This plugin adds a very simple F<README> file to the distribution, citing the
dist's name, version, abstract, and license.  It may be more useful or
informative in the future.

=head1 PERL VERSION

This module should work on any version of perl still receiving updates from
the Perl 5 Porters.  This means it should work on any version of perl
released in the last two to three years.  (That is, if the most recently
released version is v5.40, then this module should work on both v5.40 and
v5.38.)

Although it may work on older versions of perl, no guarantee is made that the
minimum required version will not be increased.  The version may be increased
for any reason, and there is no promise that patches will be accepted to
lower the minimum required perl.

=head1 AUTHOR

Ricardo SIGNES 😏 <cpan@semiotic.systems>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Ricardo SIGNES.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
