/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.ForClause;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;

public class ForClausePull
extends TuplePull {
    protected TuplePull base;
    protected ForClause forClause;
    protected SequenceIterator currentIteration;

    public ForClausePull(TuplePull base, ForClause forClause) {
        this.base = base;
        this.forClause = forClause;
    }

    public boolean nextTuple(XPathContext context) throws XPathException {
        while (true) {
            Object next;
            if (this.currentIteration == null) {
                if (!this.base.nextTuple(context)) {
                    return false;
                }
                this.currentIteration = this.forClause.getSequence().iterate(context);
            }
            if ((next = this.currentIteration.next()) != null) {
                context.setLocalVariable(this.forClause.getRangeVariable().getLocalSlotNumber(), (ValueRepresentation)next);
                if (this.forClause.getPositionVariable() != null) {
                    context.setLocalVariable(this.forClause.getPositionVariable().getLocalSlotNumber(), new Int64Value(this.currentIteration.position()));
                }
                return true;
            }
            this.currentIteration = null;
        }
    }

    public void close() {
        this.base.close();
        if (this.currentIteration != null) {
            this.currentIteration.close();
        }
    }
}

