/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DayTimeDurationValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Adjust
extends SystemFunction
implements CallableExpression {
    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av1 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (av1 == null) {
            return null;
        }
        CalendarValue in = (CalendarValue)av1;
        int nargs = this.argument.length;
        if (nargs == 1) {
            return in.adjustTimezone(context.getImplicitTimezone());
        }
        AtomicValue av2 = (AtomicValue)this.argument[1].evaluateItem(context);
        if (av2 == null) {
            return in.removeTimezone();
        }
        return this.adjustToExplicitTimezone(in, (DayTimeDurationValue)av2, context);
    }

    private Item adjustToExplicitTimezone(CalendarValue in, DayTimeDurationValue tz, XPathContext context) throws XPathException {
        long microseconds = tz.getLengthInMicroseconds();
        if (microseconds % 60000000L != 0L) {
            XPathException err = new XPathException("Timezone is not an integral number of minutes", "FODT0003");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        int tzminutes = (int)(microseconds / 60000000L);
        if (Math.abs(tzminutes) > 840) {
            XPathException err = new XPathException("Timezone out of range (-14:00 to +14:00)", "FODT0003");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        return in.adjustTimezone(tzminutes);
    }

    public SequenceIterator<? extends Item> call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        CalendarValue in = (CalendarValue)arguments[0].next();
        if (in == null) {
            return EmptyIterator.emptyIterator();
        }
        if (arguments.length == 1) {
            return SingletonIterator.makeIterator(in.adjustTimezone(context.getImplicitTimezone()));
        }
        DayTimeDurationValue tz = (DayTimeDurationValue)arguments[1].next();
        if (tz == null) {
            return SingletonIterator.makeIterator(in.removeTimezone());
        }
        return SingletonIterator.makeIterator(this.adjustToExplicitTimezone(in, tz, context));
    }
}

