/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.regex.RegexIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class RegexGroup
extends SystemFunction {
    public Item evaluateItem(XPathContext c) throws XPathException {
        AtomicValue gp0 = (AtomicValue)this.argument[0].evaluateItem(c);
        int gp = (int)((NumericValue)gp0).longValue();
        return StringValue.makeStringValue(RegexGroup.getGroup(gp, c));
    }

    public static String getGroup(int gp, XPathContext c) {
        RegexIterator iter = c.getCurrentRegexIterator();
        if (iter == null) {
            return "";
        }
        String s = iter.getRegexGroup(gp);
        if (s == null) {
            return "";
        }
        return s;
    }

    public int getIntrinsicDependencies() {
        return 64;
    }
}

