/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.regex.JRegularExpression;
import net.sf.saxon.functions.regex.RegularExpression;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class Replace
extends SystemFunction
implements CallableExpression {
    private RegularExpression regexp;
    private boolean allow30features = false;
    private boolean replacementChecked = false;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.allow30features = DecimalValue.THREE.equals(visitor.getStaticContext().getXPathLanguageLevel());
        Expression e = this.simplifyArguments(visitor);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    private void maybePrecompile(ExpressionVisitor visitor) throws XPathException {
        if (this.regexp == null) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 3, visitor.getStaticContext());
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
            if (this.regexp != null && this.regexp.matches("")) {
                err = new XPathException("The regular expression in replace() must not be one that matches a zero-length string");
                err.setErrorCode("FORX0003");
                err.setLocator(this);
                throw err;
            }
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        if (this.argument[2] instanceof StringLiteral) {
            String rep = ((StringLiteral)this.argument[2]).getStringValue();
            String msg = Replace.checkReplacement(rep);
            this.replacementChecked = true;
            if (msg != null) {
                XPathException ex = new XPathException(msg, "FORX0004");
                ex.setLocator(this);
                return new ErrorExpression(ex);
            }
        }
        return e;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        return this.eval((StringValue)this.argument[0].evaluateItem(c), (StringValue)this.argument[1].evaluateItem(c), (StringValue)this.argument[2].evaluateItem(c), this.argument.length == 3 ? null : (StringValue)this.argument[3].evaluateItem(c), c);
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        Item result = this.eval((StringValue)arguments[0].next(), (StringValue)arguments[1].next(), (StringValue)arguments[2].next(), arguments.length == 3 ? null : (StringValue)arguments[3].next(), context);
        return Value.asIterator(result);
    }

    private Item eval(StringValue inputArg, StringValue regexArg, StringValue replaceArg, StringValue flagsArg, XPathContext context) throws XPathException {
        RegularExpression re;
        String msg;
        if (inputArg == null) {
            inputArg = StringValue.EMPTY_STRING;
        }
        CharSequence replacement = replaceArg.getStringValueCS();
        if (!this.replacementChecked && (msg = Replace.checkReplacement(replacement)) != null) {
            this.dynamicError(msg, "FORX0004", context);
        }
        if ((re = this.regexp) == null) {
            CharSequence flags = flagsArg == null ? "" : flagsArg.getStringValueCS();
            try {
                int flagBits = JRegularExpression.setFlags(flags);
                int options = 2;
                if (context.getConfiguration().getXMLVersion() == 11) {
                    options |= 1;
                }
                if (context.getConfiguration().getXsdVersion() == 11) {
                    options |= 0x20;
                }
                if (this.allow30features) {
                    options |= 4;
                }
                re = new JRegularExpression(regexArg.getStringValueCS(), options, flagBits, null);
            }
            catch (XPathException err) {
                XPathException de = new XPathException(err);
                de.setErrorCode("FORX0002");
                de.setXPathContext(context);
                de.setLocator(this);
                throw de;
            }
            catch (PatternSyntaxException err) {
                XPathException de = new XPathException(err);
                de.setErrorCode("FORX0002");
                de.setXPathContext(context);
                de.setLocator(this);
                throw de;
            }
            if (re.matches("")) {
                this.dynamicError("The regular expression in replace() must not be one that matches a zero-length string", "FORX0003", context);
            }
        }
        String input = inputArg.getStringValue();
        CharSequence res = re.replace(input, replacement);
        return StringValue.makeStringValue(res);
    }

    public static String checkReplacement(CharSequence rep) {
        for (int i = 0; i < rep.length(); ++i) {
            char next;
            char c = rep.charAt(i);
            if (c == '$') {
                if (i + 1 < rep.length()) {
                    if ((next = rep.charAt(++i)) >= '0' && next <= '9') continue;
                    return "Invalid replacement string in replace(): $ sign must be followed by digit 0-9";
                }
                return "Invalid replacement string in replace(): $ sign at end of string";
            }
            if (c != '\\') continue;
            if (i + 1 < rep.length()) {
                if ((next = rep.charAt(++i)) == '\\' || next == '$') continue;
                return "Invalid replacement string in replace(): \\ character must be followed by \\ or $";
            }
            return "Invalid replacement string in replace(): \\ character at end of string";
        }
        return null;
    }
}

