/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Whitespace;

public class XSLForEach
extends StyleElement {
    private Expression select = null;
    private boolean containsTailCall = false;
    private Expression threads = null;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLSort;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    protected boolean markTailCalls() {
        assert (this.select != null);
        if (Cardinality.allowsMany(this.select.getCardinality())) {
            return false;
        }
        StyleElement last = this.getLastChildInstruction();
        this.containsTailCall = last != null && last.markTailCalls();
        return this.containsTailCall;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("threads") && atts.getURI(a).equals("http://saxon.sf.net/")) {
                String threadsAtt = Whitespace.trim(atts.getValue(a));
                this.threads = this.makeAttributeValueTemplate(threadsAtt);
                if (this.getPreparedStylesheet().isCompileWithTracing()) {
                    this.compileWarning("saxon:threads - no multithreading takes place when compiling with trace enabled", "SXWN9012");
                    this.threads = new StringLiteral("0");
                    continue;
                }
                if ("EE".equals(this.getConfiguration().getEditionCode())) continue;
                this.compileWarning("saxon:threads - ignored when not running Saxon-EE", "SXWN9013");
                this.threads = new StringLiteral("0");
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.checkSortComesFirst(false);
        this.select = this.typeCheck("select", this.select);
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty xsl:for-each instruction has no effect", "SXWN9009");
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        Expression block;
        SortKeyDefinition[] sortKeys = this.makeSortKeys(decl);
        Expression sortedSequence = this.select;
        if (sortKeys != null) {
            sortedSequence = new SortExpression(this.select, sortKeys);
        }
        if ((block = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true)) == null) {
            return Literal.makeEmptySequence();
        }
        try {
            return new ForEach(sortedSequence, this.makeExpressionVisitor().simplify(block), this.containsTailCall, this.threads);
        }
        catch (XPathException err) {
            this.compileError(err);
            return null;
        }
    }
}

