/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.Iterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.NodeWrappingFunction;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeWrappingAxisIterator<T extends NodeInfo, B>
implements AxisIterator<T>,
LookaheadIterator<T>,
UnfailingIterator<T> {
    private int position = 0;
    private T current = null;
    private Iterator<B> base;
    private NodeWrappingFunction<B, T> wrappingFunction;

    public NodeWrappingAxisIterator(Iterator<B> base, NodeWrappingFunction<B, T> wrappingFunction) {
        this.base = base;
        this.position = 0;
        this.current = null;
        this.wrappingFunction = wrappingFunction;
    }

    @Override
    public boolean moveNext() {
        return this.next() != null;
    }

    @Override
    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        return this.current.iterateAxis(axis, test);
    }

    @Override
    public Value atomize() throws XPathException {
        return this.current.atomize();
    }

    @Override
    public CharSequence getStringValue() {
        return this.current.getStringValue();
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    @Override
    public T next() {
        if (this.base.hasNext()) {
            this.current = this.wrappingFunction.wrap(this.base.next());
            ++this.position;
        } else {
            this.current = null;
            this.position = -1;
        }
        return this.current;
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
    }

    @Override
    public abstract AxisIterator<T> getAnother();

    @Override
    public int getProperties() {
        return 4;
    }
}

