/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.ocf.OCFPackage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class OCFZipPackage
extends OCFPackage {
    private ZipFile zip;
    private List<String> allEntries = null;
    private Set<String> fileEntries;
    private Set<String> dirEntries;

    public OCFZipPackage(ZipFile zip) {
        this.zip = zip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listEntries() throws IOException {
        ZipFile zipFile = this.zip;
        synchronized (zipFile) {
            this.allEntries = new LinkedList<String>();
            this.fileEntries = new HashSet<String>();
            this.dirEntries = new HashSet<String>();
            Enumeration<? extends ZipEntry> entries = this.zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.allEntries.add(entry.getName());
                if (entry.isDirectory()) {
                    this.dirEntries.add(entry.getName());
                    continue;
                }
                this.fileEntries.add(entry.getName());
            }
        }
    }

    @Override
    public boolean hasEntry(String name) {
        return this.zip.getEntry(name) != null;
    }

    @Override
    public long getTimeEntry(String name) {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return 0L;
        }
        return entry.getTime();
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        InputStream in = this.zip.getInputStream(entry);
        EncryptionFilter filter = (EncryptionFilter)this.enc.get(name);
        if (filter == null) {
            return in;
        }
        if (filter.canDecrypt()) {
            return filter.decrypt(in);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getEntries() throws IOException {
        ZipFile zipFile = this.zip;
        synchronized (zipFile) {
            if (this.allEntries == null) {
                this.listEntries();
            }
        }
        return Collections.unmodifiableList(this.allEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getFileEntries() throws IOException {
        ZipFile zipFile = this.zip;
        synchronized (zipFile) {
            if (this.allEntries == null) {
                this.listEntries();
            }
        }
        return Collections.unmodifiableSet(this.fileEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDirectoryEntries() throws IOException {
        ZipFile zipFile = this.zip;
        synchronized (zipFile) {
            if (this.allEntries == null) {
                this.listEntries();
            }
        }
        return Collections.unmodifiableSet(this.dirEntries);
    }
}

