use strict;
use Test::More tests => 15;

use Lingua::JA::Regular;

use constant HANKAKU_ASCII => q{-,.:;?!^~_/\|`'"()[]{}+=<>$%#&*@0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz};

use constant ZENKAKU_ASCII => qq{\xA1\xDD\xA1\xA4\xA1\xA5\xA1\xA7\xA1\xA8\xA1\xA9\xA1\xAA\xA1\xB0\xA1\xB1\xA1\xB2\xA1\xBF\xA1\xEF\xA1\xC3\xA1\xAE\xA1\xC7\xA1\xC9\xA1\xCA\xA1\xCB\xA1\xCE\xA1\xCF\xA1\xD0\xA1\xD1\xA1\xDC\xA1\xE1\xA1\xE3\xA1\xE4\xA1\xF0\xA1\xF3\xA1\xF4\xA1\xF5\xA1\xF6\xA1\xF7\xA3\xB0\xA3\xB1\xA3\xB2\xA3\xB3\xA3\xB4\xA3\xB5\xA3\xB6\xA3\xB7\xA3\xB8\xA3\xB9\xA3\xC1\xA3\xC2\xA3\xC3\xA3\xC4\xA3\xC5\xA3\xC6\xA3\xC7\xA3\xC8\xA3\xC9\xA3\xCA\xA3\xCB\xA3\xCC\xA3\xCD\xA3\xCE\xA3\xCF\xA3\xD0\xA3\xD1\xA3\xD2\xA3\xD3\xA3\xD4\xA3\xD5\xA3\xD6\xA3\xD7\xA3\xD8\xA3\xD9\xA3\xDA\xA3\xE1\xA3\xE2\xA3\xE3\xA3\xE4\xA3\xE5\xA3\xE6\xA3\xE7\xA3\xE8\xA3\xE9\xA3\xEA\xA3\xEB\xA3\xEC\xA3\xED\xA3\xEE\xA3\xEF\xA3\xF0\xA3\xF1\xA3\xF2\xA3\xF3\xA3\xF4\xA3\xF5\xA3\xF6\xA3\xF7\xA3\xF8\xA3\xF9\xA3\xFA};

use constant HANKAKU_KANA => qq{\x8E\xB1\x8E\xB2\x8E\xB3\x8E\xB4\x8E\xB5\x8E\xB6\x8E\xB7\x8E\xB8\x8E\xB9\x8E\xBA\x8E\xBB\x8E\xBC\x8E\xBD\x8E\xBE\x8E\xBF\x8E\xC0\x8E\xC1\x8E\xC2\x8E\xC3\x8E\xC4\x8E\xC5\x8E\xC6\x8E\xC7\x8E\xC8\x8E\xC9\x8E\xCA\x8E\xCB\x8E\xCC\x8E\xCD\x8E\xCE\x8E\xCF\x8E\xD0\x8E\xD1\x8E\xD2\x8E\xD3\x8E\xD4\x8E\xD5\x8E\xD6\x8E\xD7\x8E\xD8\x8E\xD9\x8E\xDA\x8E\xDB\x8E\xDC\x8E\xDD\x8E\xB6\x8E\xDE\x8E\xB7\x8E\xDE\x8E\xB8\x8E\xDE\x8E\xB9\x8E\xDE\x8E\xBA\x8E\xDE\x8E\xBB\x8E\xDE\x8E\xBC\x8E\xDE\x8E\xBD\x8E\xDE\x8E\xBE\x8E\xDE\x8E\xBF\x8E\xDE\x8E\xC0\x8E\xDE\x8E\xC1\x8E\xDE\x8E\xC2\x8E\xDE\x8E\xC3\x8E\xDE\x8E\xC4\x8E\xDE\x8E\xCA\x8E\xDE\x8E\xCB\x8E\xDE\x8E\xCC\x8E\xDE\x8E\xCD\x8E\xDE\x8E\xCE\x8E\xDE\x8E\xCA\x8E\xDF\x8E\xCB\x8E\xDF\x8E\xCB\x8E\xDF\x8E\xCD\x8E\xDF\x8E\xCE\x8E\xDF\x8E\xA7\x8E\xA8\x8E\xA9\x8E\xAA\x8E\xAB\x8E\xAC\x8E\xAD\x8E\xAE\x8E\xA5\x8E\xDE\x8E\xDF};

use constant ZENKAKU_HIRA => qq{\xA4\xA2\xA4\xA4\xA4\xA6\xA4\xA8\xA4\xAA\xA4\xAB\xA4\xAD\xA4\xAF\xA4\xB1\xA4\xB3\xA4\xB5\xA4\xB7\xA4\xB9\xA4\xBB\xA4\xBD\xA4\xBF\xA4\xC1\xA4\xC4\xA4\xC6\xA4\xC8\xA4\xCA\xA4\xCB\xA4\xCC\xA4\xCD\xA4\xCE\xA4\xCF\xA4\xD2\xA4\xD5\xA4\xD8\xA4\xDB\xA4\xDE\xA4\xDF\xA4\xE0\xA4\xE1\xA4\xE2\xA4\xE4\xA4\xE6\xA4\xE8\xA4\xE9\xA4\xEA\xA4\xEB\xA4\xEC\xA4\xED\xA4\xEF\xA4\xF3\xA4\xAC\xA4\xAE\xA4\xB0\xA4\xB2\xA4\xB4\xA4\xB6\xA4\xB8\xA4\xBA\xA4\xBC\xA4\xBE\xA4\xC0\xA4\xC2\xA4\xC5\xA4\xC7\xA4\xC9\xA4\xD0\xA4\xD3\xA4\xD6\xA4\xD9\xA4\xDC\xA4\xD1\xA4\xD4\xA4\xD4\xA4\xDA\xA4\xDD\xA4\xA1\xA4\xA3\xA4\xA5\xA4\xA7\xA4\xA9\xA4\xE3\xA4\xE5\xA4\xE7\xA1\xA6\xA1\xAB\xA1\xAC};

use constant ZENKAKU_KATA => qq{\xA5\xA2\xA5\xA4\xA5\xA6\xA5\xA8\xA5\xAA\xA5\xAB\xA5\xAD\xA5\xAF\xA5\xB1\xA5\xB3\xA5\xB5\xA5\xB7\xA5\xB9\xA5\xBB\xA5\xBD\xA5\xBF\xA5\xC1\xA5\xC4\xA5\xC6\xA5\xC8\xA5\xCA\xA5\xCB\xA5\xCC\xA5\xCD\xA5\xCE\xA5\xCF\xA5\xD2\xA5\xD5\xA5\xD8\xA5\xDB\xA5\xDE\xA5\xDF\xA5\xE0\xA5\xE1\xA5\xE2\xA5\xE4\xA5\xE6\xA5\xE8\xA5\xE9\xA5\xEA\xA5\xEB\xA5\xEC\xA5\xED\xA5\xEF\xA5\xF3\xA5\xAC\xA5\xAE\xA5\xB0\xA5\xB2\xA5\xB4\xA5\xB6\xA5\xB8\xA5\xBA\xA5\xBC\xA5\xBE\xA5\xC0\xA5\xC2\xA5\xC5\xA5\xC7\xA5\xC9\xA5\xD0\xA5\xD3\xA5\xD6\xA5\xD9\xA5\xDC\xA5\xD1\xA5\xD4\xA5\xD4\xA5\xDA\xA5\xDD\xA5\xA1\xA5\xA3\xA5\xA5\xA5\xA7\xA5\xA9\xA5\xE3\xA5\xE5\xA5\xE7\xA1\xA6\xA1\xAB\xA1\xAC};

use constant KANJI_UNDEF => "\xFC\xE2";
use constant KANJI_ALT   => "\xB9\xE2";

use constant WIN_UNDEF => qq{\xAD\xA1\xAD\xA2\xAD\xA3\xAD\xA4\xAD\xA5\xAD\xA6\xAD\xA7\xAD\xA8\xAD\xA9\xAD\xAA\xAD\xAB\xAD\xAC\xAD\xAD\xAD\xAE\xAD\xAF\xAD\xB0\xAD\xB1\xAD\xB2\xAD\xB3\xAD\xB4\xAD\xB5\xAD\xB6\xAD\xB7\xAD\xB8\xAD\xB9\xAD\xBA\xAD\xBB\xAD\xBC\xAD\xBD\xAD\xBE\xAD\xC0\xAD\xC1\xAD\xC2\xAD\xC3\xAD\xC4\xAD\xC5\xAD\xC6\xAD\xC7\xAD\xC8\xAD\xC9\xAD\xCA\xAD\xCB\xAD\xCC\xAD\xCD\xAD\xCE\xAD\xCF\xAD\xD0\xAD\xD1\xAD\xD2\xAD\xD3\xAD\xD4\xAD\xD5\xAD\xDF\xAD\xE0\xAD\xE1\xAD\xE2\xAD\xE3\xAD\xE4\xAD\xE5\xAD\xE6\xAD\xE7\xAD\xE8\xAD\xE9\xAD\xEA\xAD\xEB\xAD\xEC\xAD\xED\xAD\xEE\xAD\xEF};

use constant WIN_ALT => qq{(1)(2)(3)(4)(5)(6)(7)(8)(9)(10)(11)(12)(13)(14)(15)(16)(17)(18)(19)(20)IIIIIIIVVVIVIIVIIIIXX\xA5\xDF\xA5\xEA\xA5\xAD\xA5\xED\xA5\xBB\xA5\xF3\xA5\xC1\xA5\xE1\xA1\xBC\xA5\xC8\xA5\xEB\xA5\xB0\xA5\xE9\xA5\xE0\xA5\xC8\xA5\xF3\xA5\xA2\xA1\xBC\xA5\xEB\xA5\xD8\xA5\xAF\xA5\xBF\xA1\xBC\xA5\xEB\xA5\xEA\xA5\xC3\xA5\xC8\xA5\xEB\xA5\xEF\xA5\xC3\xA5\xC8\xA5\xAB\xA5\xED\xA5\xEA\xA1\xBC\xA5\xC9\xA5\xEB\xA5\xBB\xA5\xF3\xA5\xC8\xA5\xD1\xA1\xBC\xA5\xBB\xA5\xF3\xA5\xC8\xA5\xDF\xA5\xEA\xA5\xD0\xA1\xBC\xA5\xEB\xA5\xDA\xA1\xBC\xA5\xB8mmcmkmmgkgcc\xCA\xBF\xC0\xAE""No.K.K.TEL(\xBE\xE5)(\xC3\xE6)(\xB2\xBC)(\xBA\xB8)(\xB1\xA6)(\xB3\xF4)(\xCD\xAD)(\xC2\xE5)\xCC\xC0\xBC\xA3\xC2\xE7\xC0\xB5\xBE\xBC\xCF\xC2};

use constant MAC_UNDEF => "\xAD\xAE\xAF\xCE";
use constant MAC_ALT   => "(\xB3\xF4)\xA5\xF2\xA1\xAB";

	my $regular = Lingua::JA::Regular->new("\r\n\r\n" . ZENKAKU_ASCII . HANKAKU_KANA . "\r\n\r\nabc     ")->regular;
	ok $regular eq HANKAKU_ASCII . ZENKAKU_KATA . "\n\nabc", 'regular';

	my $z_ascii = Lingua::JA::Regular->new(HANKAKU_ASCII)->z_ascii->to_s;
	ok $z_ascii eq ZENKAKU_ASCII, 'z_ascii';

	my $h_ascii = Lingua::JA::Regular->new(ZENKAKU_ASCII)->h_ascii->to_s;
	ok $h_ascii eq HANKAKU_ASCII, 'h_ascii';

	my $z_kana = Lingua::JA::Regular->new(HANKAKU_KANA)->z_kana->to_s;
	ok $z_kana eq ZENKAKU_KATA, 'z_kana';

	my $h_kana = Lingua::JA::Regular->new(HANKAKU_KANA)->h_kana->to_s;
	ok $h_kana eq HANKAKU_KANA, 'h_kana';
	
	my $z_space = Lingua::JA::Regular->new(" ")->z_space->to_s;
	ok $z_space eq "\xA1\xA1", 'z_space';
	
	my $h_space = Lingua::JA::Regular->new("\xA1\xA1")->h_space->to_s;
	ok $h_space eq " ", 'h_space';

	my $z_strip = Lingua::JA::Regular->new(" \xA1\xA1\n\xA1\xA1abc\xA1\xA1\n\n")->z_strip->to_s;
	ok $z_strip eq 'abc', 'z_strip';

	my $hiragana = Lingua::JA::Regular->new(ZENKAKU_KATA)->hiragana->to_s;
	ok $hiragana eq ZENKAKU_HIRA, 'hiragana';
	
	my $katakana = Lingua::JA::Regular->new(ZENKAKU_HIRA)->katakana->to_s;
	ok $katakana eq ZENKAKU_KATA, 'katakana';
	
	my $kanji = Lingua::JA::Regular->new(KANJI_UNDEF)->kanji->to_s;
	ok $kanji eq KANJI_ALT, 'kanji';

	my $win = Lingua::JA::Regular->new(WIN_UNDEF)->win->to_s;
	ok $win eq WIN_ALT, 'win';
	
	my $mac = Lingua::JA::Regular->new(MAC_UNDEF)->mac->to_s;
	ok $mac eq MAC_ALT, 'mac';

	my $geta = Lingua::JA::Regular->new(WIN_UNDEF . MAC_UNDEF)->geta->to_s;
	ok $geta eq "\xA2\xAE"x71, 'geta';
	
	my $jp_match = Lingua::JA::Regular->new("\xA2\xAE\xA2\xAE\xA2\xE8\xA2\xC1")->geta->to_s;
	ok $jp_match eq "\xA2\xAE\xA2\xAE\xA2\xE8\xA2\xC1", 'jp match';

