# Generated by default/object.tt
package Paws::AppRunner::AuthenticationConfiguration;
  use Moose;
  has AccessRoleArn => (is => 'ro', isa => 'Str');
  has ConnectionArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AppRunner::AuthenticationConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AppRunner::AuthenticationConfiguration object:

  $service_obj->Method(Att1 => { AccessRoleArn => $value, ..., ConnectionArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AppRunner::AuthenticationConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessRoleArn

=head1 DESCRIPTION

Describes resources needed to authenticate access to some source
repositories. The specific resource depends on the repository provider.

=head1 ATTRIBUTES


=head2 AccessRoleArn => Str

The Amazon Resource Name (ARN) of the IAM role that grants the App
Runner service access to a source repository. It's required for ECR
image repositories (but not for ECR Public repositories).


=head2 ConnectionArn => Str

The Amazon Resource Name (ARN) of the App Runner connection that
enables the App Runner service to connect to a source repository. It's
required for GitHub code repositories.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AppRunner>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

