/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.z.IntPredicate;

final class PrecedingIterator
extends AxisIteratorImpl {
    private TinyTree tree;
    private TinyNodeImpl startNode;
    private NodeInfo current;
    private NodeTest test;
    private int nextAncestorDepth;
    private boolean includeAncestors;
    private final IntPredicate matcher;

    public PrecedingIterator(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest, boolean includeAncestors) {
        this.includeAncestors = includeAncestors;
        this.test = nodeTest;
        this.tree = doc;
        this.startNode = node;
        this.current = this.startNode;
        this.nextAncestorDepth = doc.depth[node.nodeNr] - 1;
        this.matcher = nodeTest.getMatcher(doc);
    }

    public NodeInfo next() {
        if (this.current == null) {
            return null;
        }
        int nextNodeNr = ((TinyNodeImpl)this.current).nodeNr;
        do {
            if (!this.includeAncestors) {
                --nextNodeNr;
                while (this.nextAncestorDepth >= 0 && this.tree.depth[nextNodeNr] == this.nextAncestorDepth) {
                    if (this.nextAncestorDepth-- <= 0) {
                        this.current = null;
                        return null;
                    }
                    --nextNodeNr;
                }
            } else {
                if (this.tree.depth[nextNodeNr] == 0) {
                    this.current = null;
                    return null;
                }
                --nextNodeNr;
            }
            if (!this.matcher.matches(nextNodeNr)) continue;
            this.current = this.tree.getNode(nextNodeNr);
            return this.current;
        } while (this.tree.depth[nextNodeNr] != 0);
        this.current = null;
        return null;
    }
}

