/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor.idempotent;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

@Metadata(label="bean", description="A memory based IdempotentRepository.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="Memory based idempotent repository")
public class MemoryIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private static final int MAX_CACHE_SIZE = 1000;
    private Map<String, Object> cache;
    private final Lock cacheAndStoreLock = new ReentrantLock();
    @Metadata(description="Maximum elements that can be stored in-memory", defaultValue="1000")
    private int cacheSize;

    public MemoryIdempotentRepository() {
    }

    public MemoryIdempotentRepository(Map<String, Object> set) {
        this.cache = set;
    }

    public static IdempotentRepository memoryIdempotentRepository() {
        return MemoryIdempotentRepository.memoryIdempotentRepository(1000);
    }

    public static IdempotentRepository memoryIdempotentRepository(int cacheSize) {
        MemoryIdempotentRepository answer = new MemoryIdempotentRepository();
        answer.setCacheSize(cacheSize);
        ServiceHelper.startService((Service)answer);
        return answer;
    }

    public static IdempotentRepository memoryIdempotentRepository(Map<String, Object> cache) {
        return new MemoryIdempotentRepository(cache);
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        this.cacheAndStoreLock.lock();
        try {
            if (this.cache.containsKey(key)) {
                boolean bl = false;
                return bl;
            }
            this.cache.put(key, key);
            boolean bl = true;
            return bl;
        }
        finally {
            this.cacheAndStoreLock.unlock();
        }
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        this.cacheAndStoreLock.lock();
        try {
            boolean bl = this.cache.containsKey(key);
            return bl;
        }
        finally {
            this.cacheAndStoreLock.unlock();
        }
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        this.cacheAndStoreLock.lock();
        try {
            boolean bl = this.cache.remove(key) != null;
            return bl;
        }
        finally {
            this.cacheAndStoreLock.unlock();
        }
    }

    public boolean confirm(String key) {
        return true;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cacheAndStoreLock.lock();
        try {
            this.cache.clear();
        }
        finally {
            this.cacheAndStoreLock.unlock();
        }
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }

    @ManagedAttribute(description="The current cache size")
    public int getCacheSize() {
        return this.cache.size();
    }

    @ManagedAttribute(description="The maximum cache size")
    public int getMaxCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    protected void doStart() throws Exception {
        if (this.cache == null) {
            this.cache = LRUCacheFactory.newLRUCache(this.cacheSize <= 0 ? 1000 : this.cacheSize);
        }
    }

    protected void doStop() throws Exception {
        this.cache.clear();
    }
}

