/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.Map;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.TypeConvertible;

final class TypeResolverHelper {
    private TypeResolverHelper() {
    }

    static TypeConverter doLookup(Class<?> toType, Class<?> fromType, Map<TypeConvertible<?, ?>, TypeConverter> converters) {
        return TypeResolverHelper.doLookup(new TypeConvertible(fromType, toType), converters);
    }

    private static TypeConverter doLookup(TypeConvertible<?, ?> typeConvertible, Map<TypeConvertible<?, ?>, TypeConverter> converters) {
        TypeConverter typeConverter = converters.get(typeConvertible);
        if (typeConverter != null) {
            return typeConverter;
        }
        TypeConverter superConverterTc = TypeResolverHelper.tryMatch(typeConvertible, converters);
        if (superConverterTc != null) {
            return superConverterTc;
        }
        TypeConverter primitiveAwareConverter = TypeResolverHelper.tryPrimitive(typeConvertible, converters);
        if (primitiveAwareConverter != null) {
            return primitiveAwareConverter;
        }
        if (!typeConvertible.getFrom().equals(Object.class)) {
            TypeConverter assignableConverter = TypeResolverHelper.tryAssignableFrom(typeConvertible, converters);
            if (assignableConverter != null) {
                return assignableConverter;
            }
            TypeConverter objConverter = converters.get(new TypeConvertible(Object.class, typeConvertible.getTo()));
            if (objConverter != null) {
                return objConverter;
            }
        }
        return null;
    }

    static TypeConverter tryAssignableFrom(TypeConvertible<?, ?> typeConvertible, Map<TypeConvertible<?, ?>, TypeConverter> converters) {
        for (Map.Entry<TypeConvertible<?, ?>, TypeConverter> entry : converters.entrySet()) {
            TypeConvertible<?, ?> key = entry.getKey();
            if (key.isAssignableMatch(typeConvertible)) {
                return entry.getValue();
            }
            if (!typeConvertible.isAssignableMatch(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    static TypeConverter tryMatch(TypeConvertible<?, ?> typeConvertible, Map<TypeConvertible<?, ?>, TypeConverter> converters) {
        for (Map.Entry<TypeConvertible<?, ?>, TypeConverter> entry : converters.entrySet()) {
            if (!entry.getKey().matches(typeConvertible)) continue;
            return entry.getValue();
        }
        return null;
    }

    static TypeConverter tryPrimitive(TypeConvertible<?, ?> typeConvertible, Map<TypeConvertible<?, ?>, TypeConverter> converters) {
        for (Map.Entry<TypeConvertible<?, ?>, TypeConverter> entry : converters.entrySet()) {
            if (!entry.getKey().matchesPrimitive(typeConvertible)) continue;
            return entry.getValue();
        }
        return null;
    }
}

