/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.HdrHistogram.SingleWriterRecorder;
import org.apache.activemq.artemis.api.core.ObjLongPair;
import org.apache.activemq.artemis.cli.commands.messages.perf.AsyncJms2ProducerFacade;
import org.apache.activemq.artemis.cli.commands.messages.perf.BenchmarkService;
import org.apache.activemq.artemis.cli.commands.messages.perf.MicrosTimeProvider;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerLoadGenerator;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerMaxLoadGenerator;
import org.apache.activemq.artemis.cli.commands.messages.perf.ProducerTargetRateLoadGenerator;

public final class ProducerBenchmark
implements BenchmarkService {
    private final ConnectionFactory factory;
    private final MicrosTimeProvider timeProvider;
    private final EventLoopGroup eventLoopGroup;
    private final int producers;
    private final long messageCount;
    private final String group;
    private final long ttl;
    private final int messageSize;
    private final Destination[] destinations;
    private final boolean persistent;
    private final long maxPending;
    private final long transactionCapacity;
    private final Long messageRate;
    private final boolean sharedConnections;
    private final boolean enableTimestamp;
    private final boolean enableMessageID;
    private Set<Connection> connections;
    private ProducerLoadGenerator[] generators;
    private boolean started;
    private boolean closed;
    private final Map<Destination, List<AsyncJms2ProducerFacade>> producersPerDestination;
    private CompletableFuture<?> allGeneratorClosed;

    public ProducerBenchmark(ConnectionFactory factory, MicrosTimeProvider timeProvider, EventLoopGroup loopGroup, int producers, long messageCount, boolean sharedConnections, String group, long ttl, int messageSize, Destination[] destinations, boolean persistent, long maxPending, long transactionCapacity, Long messageRate, boolean enableMessageID, boolean enableTimestamp) {
        this.factory = factory;
        this.timeProvider = timeProvider;
        this.eventLoopGroup = loopGroup;
        this.producers = producers;
        this.messageCount = messageCount;
        this.sharedConnections = sharedConnections;
        this.group = group;
        this.ttl = ttl;
        this.messageSize = messageSize;
        this.destinations = destinations;
        this.persistent = persistent;
        this.maxPending = maxPending;
        this.transactionCapacity = transactionCapacity;
        this.messageRate = messageRate;
        this.started = false;
        this.closed = false;
        this.connections = new HashSet<Connection>();
        this.producersPerDestination = new HashMap<Destination, List<AsyncJms2ProducerFacade>>(destinations.length);
        this.enableMessageID = enableMessageID;
        this.enableTimestamp = enableTimestamp;
    }

    private synchronized Stream<ObjLongPair<Destination>> messageSentPerDestination() {
        return this.producersPerDestination.entrySet().stream().map(producers -> new ObjLongPair(producers.getKey(), ((List)producers.getValue()).stream().mapToLong(AsyncJms2ProducerFacade::getMessageSent).sum()));
    }

    public synchronized long expectedTotalMessageCountToReceive(int sharedSubscriptions, int consumersPerDestination) {
        return ProducerBenchmark.expectedTotalMessageCountToReceive(this.messageSentPerDestination(), sharedSubscriptions, consumersPerDestination);
    }

    public static long expectedTotalMessageCountToReceive(Stream<ObjLongPair<Destination>> messageSentPerDestination, int sharedSubscriptions, int consumersPerDestination) {
        return messageSentPerDestination.mapToLong(messagesPerDestination -> {
            if (messagesPerDestination.getA() instanceof Topic) {
                int subscribers = sharedSubscriptions > 0 ? sharedSubscriptions : consumersPerDestination;
                return (long)subscribers * messagesPerDestination.getB();
            }
            assert (messagesPerDestination.getA() instanceof Queue);
            return messagesPerDestination.getB();
        }).sum();
    }

    public synchronized ProducerLoadGenerator[] getGenerators() {
        return this.generators;
    }

    @Override
    public synchronized boolean anyError() {
        if (!this.started || this.closed) {
            return false;
        }
        for (ProducerLoadGenerator loadGenerator : this.generators) {
            if (loadGenerator.getFatalException() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isRunning() {
        if (!this.started || this.closed) {
            return false;
        }
        ProducerLoadGenerator[] generators = this.generators;
        if (generators == null) {
            return false;
        }
        boolean running = false;
        for (ProducerLoadGenerator loadGenerator : generators) {
            if (!loadGenerator.isCompleted()) {
                running = true;
                continue;
            }
            if (loadGenerator.getFatalException() == null) continue;
            running = false;
            break;
        }
        return running;
    }

    @Override
    public synchronized ProducerBenchmark start() {
        Connection[] exclusiveConnections;
        if (this.started) {
            return this;
        }
        this.producersPerDestination.clear();
        this.started = true;
        this.closed = false;
        int totalProducers = this.destinations.length * this.producers;
        IdentityHashMap sharedConnections = this.sharedConnections ? new IdentityHashMap() : null;
        Connection[] connectionArray = exclusiveConnections = !this.sharedConnections ? new Connection[totalProducers] : null;
        if (this.sharedConnections) {
            this.eventLoopGroup.forEach(eventExecutor -> {
                try {
                    Connection connection = this.factory.createConnection();
                    this.connections.add(connection);
                    sharedConnections.put(eventExecutor, connection);
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            for (int i = 0; i < totalProducers; ++i) {
                try {
                    Connection connection2;
                    exclusiveConnections[i] = connection2 = this.factory.createConnection();
                    this.connections.add(connection2);
                    continue;
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.connections.forEach(connection -> {
            try {
                connection.start();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        });
        AtomicLong producerId = new AtomicLong(1L);
        byte[] messageContent = new byte[this.messageSize];
        Arrays.fill(messageContent, (byte)1);
        this.generators = new ProducerLoadGenerator[totalProducers];
        ArrayList<AsyncJms2ProducerFacade> allProducers = new ArrayList<AsyncJms2ProducerFacade>(totalProducers);
        int producerSequence = 0;
        int messageCountPerProducer = (int)(this.messageCount / (long)totalProducers);
        long remainingMessageCount = this.messageCount;
        Long messageRatePerProducer = this.messageRate == null ? null : Long.valueOf(this.messageRate / (long)totalProducers);
        Long remainingMessageRate = this.messageRate;
        for (int d = 0; d < this.destinations.length; ++d) {
            Destination destination = this.destinations[d];
            ArrayList<AsyncJms2ProducerFacade> producers = new ArrayList<AsyncJms2ProducerFacade>(this.producers);
            this.producersPerDestination.put(destination, producers);
            for (int i = 0; i < this.producers; ++i) {
                Long ratePeriodNanos;
                BooleanSupplier keepOnSendingStrategy;
                MessageProducer producer;
                Session session;
                EventLoop eventLoop = this.eventLoopGroup.next();
                Connection connection3 = this.sharedConnections ? (Connection)sharedConnections.get(eventLoop) : exclusiveConnections[producerSequence];
                try {
                    session = connection3.createSession(this.transactionCapacity > 0L ? 0 : 1);
                    producer = session.createProducer(destination);
                    producer.setDisableMessageID(!this.enableMessageID);
                    producer.setDisableMessageTimestamp(!this.enableTimestamp);
                    producer.setDeliveryMode(this.persistent ? 2 : 1);
                    producer.setTimeToLive(this.ttl);
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
                AsyncJms2ProducerFacade producerFacade = new AsyncJms2ProducerFacade(producerId.getAndIncrement(), session, producer, destination, this.maxPending, this.transactionCapacity);
                allProducers.add(producerFacade);
                producers.add(producerFacade);
                if (this.messageCount == 0L) {
                    keepOnSendingStrategy = () -> true;
                } else {
                    long count = Math.min((long)messageCountPerProducer, remainingMessageCount);
                    remainingMessageCount -= count;
                    keepOnSendingStrategy = () -> producerFacade.getMessageSent() < count;
                }
                SingleWriterRecorder sendLatencyRecorder = new SingleWriterRecorder(2);
                if (messageRatePerProducer != null) {
                    long rate = Math.min(messageRatePerProducer, remainingMessageRate);
                    ratePeriodNanos = TimeUnit.SECONDS.toNanos(1L) / rate;
                    remainingMessageRate = remainingMessageRate - rate;
                } else {
                    ratePeriodNanos = null;
                }
                this.generators[producerSequence] = ratePeriodNanos != null ? new ProducerTargetRateLoadGenerator(producerFacade, (OrderedEventExecutor)eventLoop, this.timeProvider, keepOnSendingStrategy, ratePeriodNanos, this.group, messageContent, sendLatencyRecorder, new SingleWriterRecorder(2)) : new ProducerMaxLoadGenerator(producerFacade, (OrderedEventExecutor)eventLoop, this.timeProvider, keepOnSendingStrategy, this.group, messageContent, sendLatencyRecorder);
                ++producerSequence;
            }
        }
        for (int i = 0; i < totalProducers; ++i) {
            this.generators[i].getExecutor().execute((Runnable)this.generators[i]);
        }
        return this;
    }

    public synchronized CompletionStage<?> asyncClose() {
        if (!this.started || this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.allGeneratorClosed != null) {
            return this.allGeneratorClosed;
        }
        CompletableFuture[] closedGenerators = new CompletableFuture[this.generators.length];
        for (int i = 0; i < this.generators.length; ++i) {
            CompletableFuture onClosed;
            closedGenerators[i] = onClosed = new CompletableFuture();
            try {
                this.generators[i].asyncClose(() -> onClosed.complete(null)).get();
                continue;
            }
            catch (Throwable ignore) {
                closedGenerators[i].completeExceptionally(ignore);
            }
        }
        CompletableFuture<Void> allGeneratorClosed = CompletableFuture.allOf(closedGenerators);
        Connection[] openedConnections = this.connections.toArray(new Connection[this.connections.size()]);
        this.allGeneratorClosed = allGeneratorClosed.whenCompleteAsync((res, error) -> {
            ProducerBenchmark producerBenchmark = this;
            synchronized (producerBenchmark) {
                this.generators = null;
                this.started = false;
                this.closed = true;
                this.allGeneratorClosed = null;
            }
            for (Connection connection : openedConnections) {
                try {
                    connection.close();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }, (Executor)this.eventLoopGroup);
        this.connections.clear();
        return allGeneratorClosed;
    }

    @Override
    public void close() {
        this.asyncClose().toCompletableFuture().join();
    }
}

