# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
from __future__ import annotations

import pytest

from airflow.providers.google.cloud.triggers.pubsub import PubsubPullTrigger

pytest.importorskip("airflow.providers.common.messaging.providers.base_provider")


def test_message_pubsub_queue_create():
    from airflow.providers.common.messaging.providers.base_provider import BaseMessageQueueProvider
    from airflow.providers.google.event_scheduling.events.pubsub import (
        PubSubMessageQueueEventTriggerContainer,
    )

    provider = PubSubMessageQueueEventTriggerContainer()
    assert isinstance(provider, BaseMessageQueueProvider)


def test_message_pubsub_queue_trigger_class():
    from airflow.providers.google.event_scheduling.events.pubsub import (
        PubSubMessageQueueEventTriggerContainer,
    )

    provider = PubSubMessageQueueEventTriggerContainer()
    assert provider.trigger_class() == PubsubPullTrigger


def test_scheme_matches():
    from airflow.providers.google.event_scheduling.events.pubsub import (
        PubSubMessageQueueEventTriggerContainer,
    )

    provider = PubSubMessageQueueEventTriggerContainer()
    assert provider.scheme_matches("google+pubsub")
