/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientHammerTest;
import org.apache.zookeeper.test.JMXEnv;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalQuorumTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumBase.class);
    File s1dir;
    File s2dir;
    File s3dir;
    File s4dir;
    File s5dir;
    QuorumPeer s1;
    QuorumPeer s2;
    QuorumPeer s3;
    QuorumPeer s4;
    QuorumPeer s5;
    protected int port1;
    protected int port2;
    protected int port3;
    protected int port4;
    protected int port5;
    protected int leport1;
    protected int leport2;
    protected int leport3;
    protected int leport4;
    protected int leport5;
    protected int clientport1;
    protected int clientport2;
    protected int clientport3;
    protected int clientport4;
    protected int clientport5;
    Properties qp;
    protected final ClientHammerTest cht = new ClientHammerTest();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        HierarchicalQuorumTest.setupTestEnv();
        JMXEnv.setUp();
        this.setUpAll();
        this.port1 = PortAssignment.unique();
        this.port2 = PortAssignment.unique();
        this.port3 = PortAssignment.unique();
        this.port4 = PortAssignment.unique();
        this.port5 = PortAssignment.unique();
        this.leport1 = PortAssignment.unique();
        this.leport2 = PortAssignment.unique();
        this.leport3 = PortAssignment.unique();
        this.leport4 = PortAssignment.unique();
        this.leport5 = PortAssignment.unique();
        this.clientport1 = PortAssignment.unique();
        this.clientport2 = PortAssignment.unique();
        this.clientport3 = PortAssignment.unique();
        this.clientport4 = PortAssignment.unique();
        this.clientport5 = PortAssignment.unique();
        this.hostPort = "127.0.0.1:" + this.clientport1 + ",127.0.0.1:" + this.clientport2 + ",127.0.0.1:" + this.clientport3 + ",127.0.0.1:" + this.clientport4 + ",127.0.0.1:" + this.clientport5;
        LOG.info("Ports are: {}", (Object)this.hostPort);
        this.s1dir = ClientBase.createTmpDir();
        this.s2dir = ClientBase.createTmpDir();
        this.s3dir = ClientBase.createTmpDir();
        this.s4dir = ClientBase.createTmpDir();
        this.s5dir = ClientBase.createTmpDir();
        String config = "group.1=1:2:3\ngroup.2=4:5\nweight.1=1\nweight.2=1\nweight.3=1\nweight.4=0\nweight.5=0\nserver.1=127.0.0.1:" + this.port1 + ":" + this.leport1 + ";" + this.clientport1 + "\nserver.2=127.0.0.1:" + this.port2 + ":" + this.leport2 + ";" + this.clientport2 + "\nserver.3=127.0.0.1:" + this.port3 + ":" + this.leport3 + ";" + this.clientport3 + "\nserver.4=127.0.0.1:" + this.port4 + ":" + this.leport4 + ";" + this.clientport4 + "\nserver.5=127.0.0.1:" + this.port5 + ":" + this.leport5 + ";" + this.clientport5 + "\n";
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.qp = new Properties();
        this.qp.load(is);
        this.startServers();
        this.cht.hostPort = this.hostPort;
        this.cht.setUpAll();
        LOG.info("Setup finished");
    }

    void startServers() throws Exception {
        this.startServers(false);
    }

    void startServers(boolean withObservers) throws Exception {
        int i;
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        int connectToLearnerMasterLimit = 3;
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>();
        peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress("127.0.0.1", this.port1), new InetSocketAddress("127.0.0.1", this.leport1), new InetSocketAddress("127.0.0.1", this.clientport1)));
        peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress("127.0.0.1", this.port2), new InetSocketAddress("127.0.0.1", this.leport2), new InetSocketAddress("127.0.0.1", this.clientport2)));
        peers.put(3L, new QuorumPeer.QuorumServer(3L, new InetSocketAddress("127.0.0.1", this.port3), new InetSocketAddress("127.0.0.1", this.leport3), new InetSocketAddress("127.0.0.1", this.clientport3)));
        peers.put(4L, new QuorumPeer.QuorumServer(4L, new InetSocketAddress("127.0.0.1", this.port4), new InetSocketAddress("127.0.0.1", this.leport4), new InetSocketAddress("127.0.0.1", this.clientport4), withObservers ? QuorumPeer.LearnerType.OBSERVER : QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(5L, new QuorumPeer.QuorumServer(5L, new InetSocketAddress("127.0.0.1", this.port5), new InetSocketAddress("127.0.0.1", this.leport5), new InetSocketAddress("127.0.0.1", this.clientport5), withObservers ? QuorumPeer.LearnerType.OBSERVER : QuorumPeer.LearnerType.PARTICIPANT));
        LOG.info("creating QuorumPeer 1 port {}", (Object)this.clientport1);
        if (withObservers) {
            this.qp.setProperty("server.4", "127.0.0.1:" + this.port4 + ":" + this.leport4 + ":observer;" + this.clientport4);
            this.qp.setProperty("server.5", "127.0.0.1:" + this.port5 + ":" + this.leport5 + ":observer;" + this.clientport5);
        }
        QuorumHierarchical hq1 = new QuorumHierarchical(this.qp);
        this.s1 = new QuorumPeer(peers, this.s1dir, this.s1dir, this.clientport1, 3, 1L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit, (QuorumVerifier)hq1);
        Assertions.assertEquals((int)this.clientport1, (int)this.s1.getClientPort());
        LOG.info("creating QuorumPeer 2 port {}", (Object)this.clientport2);
        QuorumHierarchical hq2 = new QuorumHierarchical(this.qp);
        this.s2 = new QuorumPeer(peers, this.s2dir, this.s2dir, this.clientport2, 3, 2L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit, (QuorumVerifier)hq2);
        Assertions.assertEquals((int)this.clientport2, (int)this.s2.getClientPort());
        LOG.info("creating QuorumPeer 3 port {}", (Object)this.clientport3);
        QuorumHierarchical hq3 = new QuorumHierarchical(this.qp);
        this.s3 = new QuorumPeer(peers, this.s3dir, this.s3dir, this.clientport3, 3, 3L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit, (QuorumVerifier)hq3);
        Assertions.assertEquals((int)this.clientport3, (int)this.s3.getClientPort());
        LOG.info("creating QuorumPeer 4 port {}", (Object)this.clientport4);
        QuorumHierarchical hq4 = new QuorumHierarchical(this.qp);
        this.s4 = new QuorumPeer(peers, this.s4dir, this.s4dir, this.clientport4, 3, 4L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit, (QuorumVerifier)hq4);
        if (withObservers) {
            this.s4.setLearnerType(QuorumPeer.LearnerType.OBSERVER);
        }
        Assertions.assertEquals((int)this.clientport4, (int)this.s4.getClientPort());
        LOG.info("creating QuorumPeer 5 port {}", (Object)this.clientport5);
        QuorumHierarchical hq5 = new QuorumHierarchical(this.qp);
        this.s5 = new QuorumPeer(peers, this.s5dir, this.s5dir, this.clientport5, 3, 5L, tickTime, initLimit, syncLimit, connectToLearnerMasterLimit, (QuorumVerifier)hq5);
        if (withObservers) {
            this.s5.setLearnerType(QuorumPeer.LearnerType.OBSERVER);
        }
        Assertions.assertEquals((int)this.clientport5, (int)this.s5.getClientPort());
        LOG.info("start QuorumPeer 1");
        this.s1.start();
        LOG.info("start QuorumPeer 2");
        this.s2.start();
        LOG.info("start QuorumPeer 3");
        this.s3.start();
        LOG.info("start QuorumPeer 4{}", (Object)(withObservers ? "(observer)" : ""));
        this.s4.start();
        LOG.info("start QuorumPeer 5{}", (Object)(withObservers ? "(observer)" : ""));
        this.s5.start();
        LOG.info("started QuorumPeer 5");
        LOG.info("Closing ports {}", (Object)this.hostPort);
        for (String hp : this.hostPort.split(",")) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(hp, CONNECTION_TIMEOUT), (String)"waiting for server up");
            LOG.info("{} is accepting client connections", (Object)hp);
        }
        int numberOfPeers = 5;
        JMXEnv.dump();
        LinkedHashSet<String> ensureNames = new LinkedHashSet<String>();
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("InMemoryDataTree");
        }
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + i + ",name2=");
        }
        for (i = 1; i <= 5; ++i) {
            for (int j = 1; j <= 5; ++j) {
                ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + j);
            }
        }
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i);
        }
        JMXEnv.ensureAll(ensureNames.toArray(new String[ensureNames.size()]));
        for (i = 1; i <= 5; ++i) {
            String bean = "org.apache.ZooKeeperService:name0=ReplicatedServer_id" + i + ",name1=replica." + i;
            JMXEnv.ensureBeanAttribute(bean, "ConfigVersion");
            JMXEnv.ensureBeanAttribute(bean, "LearnerType");
            JMXEnv.ensureBeanAttribute(bean, "ClientAddress");
            JMXEnv.ensureBeanAttribute(bean, "ElectionAddress");
            JMXEnv.ensureBeanAttribute(bean, "QuorumSystemInfo");
            JMXEnv.ensureBeanAttribute(bean, "Leader");
        }
        for (i = 1; i <= 5; ++i) {
            for (int j = 1; j <= 5; ++j) {
                if (j == i) continue;
                String bean = "org.apache.ZooKeeperService:name0=ReplicatedServer_id" + i + ",name1=replica." + j;
                JMXEnv.ensureBeanAttribute(bean, "Name");
                JMXEnv.ensureBeanAttribute(bean, "LearnerType");
                JMXEnv.ensureBeanAttribute(bean, "ClientAddress");
                JMXEnv.ensureBeanAttribute(bean, "ElectionAddress");
                JMXEnv.ensureBeanAttribute(bean, "QuorumAddress");
                JMXEnv.ensureBeanAttribute(bean, "Leader");
            }
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        LOG.info("TearDown started");
        this.cht.tearDownAll();
        LOG.info("Shutting down server 1");
        this.shutdown(this.s1);
        LOG.info("Shutting down server 2");
        this.shutdown(this.s2);
        LOG.info("Shutting down server 3");
        this.shutdown(this.s3);
        LOG.info("Shutting down server 4");
        this.shutdown(this.s4);
        LOG.info("Shutting down server 5");
        this.shutdown(this.s5);
        for (String hp : this.hostPort.split(",")) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerDown(hp, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
            LOG.info("{} is no longer accepting client connections", (Object)hp);
        }
        JMXEnv.tearDown();
    }

    protected void shutdown(QuorumPeer qp) {
        QuorumBase.shutdown(qp);
    }

    @Override
    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    @Test
    public void testHierarchicalQuorum() throws Throwable {
        this.cht.runHammer(5, 10);
    }
}

