/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.mvcc.op.proto;

import io.netty.util.Recycler;
import java.util.Arrays;
import org.apache.bookkeeper.api.kv.op.DeleteOp;
import org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;

public class ProtoDeleteOpImpl
implements DeleteOp<byte[], byte[]>,
DeleteOption<byte[]> {
    private static final Recycler<ProtoDeleteOpImpl> RECYCLER = new Recycler<ProtoDeleteOpImpl>(){

        protected ProtoDeleteOpImpl newObject(Recycler.Handle<ProtoDeleteOpImpl> handle) {
            return new ProtoDeleteOpImpl(handle);
        }
    };
    private final Recycler.Handle<ProtoDeleteOpImpl> recyclerHandle;
    private DeleteRangeRequest req;
    private byte[] key;
    private byte[] endKey;

    public static ProtoDeleteOpImpl newDeleteOp(DeleteRangeRequest req) {
        ProtoDeleteOpImpl op = (ProtoDeleteOpImpl)RECYCLER.get();
        op.setCommand(req);
        return op;
    }

    private void reset() {
        this.req = null;
        this.key = null;
        this.endKey = null;
    }

    private void setCommand(DeleteRangeRequest req) {
        this.req = req;
    }

    public byte[] key() {
        if (null != this.key) {
            return this.key;
        }
        this.key = (byte[])(null == this.req.getKey() ? null : this.req.getKey().toByteArray());
        return this.key;
    }

    public byte[] endKey() {
        if (null != this.endKey) {
            return this.endKey;
        }
        this.endKey = (byte[])(null == this.req.getRangeEnd() || 0 == this.req.getRangeEnd().size() || 1 == this.req.getRangeEnd().size() && this.req.getRangeEnd().byteAt(0) == 0 ? null : this.req.getRangeEnd().toByteArray());
        return this.endKey;
    }

    public boolean prevKv() {
        return this.req.getPrevKv();
    }

    public DeleteOption<byte[]> option() {
        return this;
    }

    public void close() {
        this.reset();
        this.recyclerHandle.recycle((Object)this);
    }

    public OpType type() {
        return OpType.DELETE;
    }

    public ProtoDeleteOpImpl(Recycler.Handle<ProtoDeleteOpImpl> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    public String toString() {
        return "ProtoDeleteOpImpl(req=" + this.req + ", key=" + Arrays.toString(this.key) + ", endKey=" + Arrays.toString(this.endKey) + ")";
    }
}

