/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.function.ToLongFunction;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundConnection;
import org.apache.cassandra.net.OutboundConnections;
import org.apache.cassandra.schema.TableMetadata;

public final class InternodeOutboundTable
extends AbstractVirtualTable {
    private static final String ADDRESS = "address";
    private static final String PORT = "port";
    private static final String DC = "dc";
    private static final String RACK = "rack";
    private static final String USING_BYTES = "using_bytes";
    private static final String USING_RESERVE_BYTES = "using_reserve_bytes";
    private static final String PENDING_COUNT = "pending_count";
    private static final String PENDING_BYTES = "pending_bytes";
    private static final String SENT_COUNT = "sent_count";
    private static final String SENT_BYTES = "sent_bytes";
    private static final String EXPIRED_COUNT = "expired_count";
    private static final String EXPIRED_BYTES = "expired_bytes";
    private static final String ERROR_COUNT = "error_count";
    private static final String ERROR_BYTES = "error_bytes";
    private static final String OVERLOAD_COUNT = "overload_count";
    private static final String OVERLOAD_BYTES = "overload_bytes";
    private static final String ACTIVE_CONNECTION_COUNT = "active_connections";
    private static final String CONNECTION_ATTEMPTS = "connection_attempts";
    private static final String SUCCESSFUL_CONNECTION_ATTEMPTS = "successful_connection_attempts";

    InternodeOutboundTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "internode_outbound").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(CompositeType.getInstance(InetAddressType.instance, Int32Type.instance))).addPartitionKeyColumn(ADDRESS, (AbstractType)InetAddressType.instance).addPartitionKeyColumn(PORT, (AbstractType)Int32Type.instance).addClusteringColumn(DC, (AbstractType)UTF8Type.instance).addClusteringColumn(RACK, (AbstractType)UTF8Type.instance).addRegularColumn(USING_BYTES, (AbstractType)LongType.instance).addRegularColumn(USING_RESERVE_BYTES, (AbstractType)LongType.instance).addRegularColumn(PENDING_COUNT, (AbstractType)LongType.instance).addRegularColumn(PENDING_BYTES, (AbstractType)LongType.instance).addRegularColumn(SENT_COUNT, (AbstractType)LongType.instance).addRegularColumn(SENT_BYTES, (AbstractType)LongType.instance).addRegularColumn(EXPIRED_COUNT, (AbstractType)LongType.instance).addRegularColumn(EXPIRED_BYTES, (AbstractType)LongType.instance).addRegularColumn(ERROR_COUNT, (AbstractType)LongType.instance).addRegularColumn(ERROR_BYTES, (AbstractType)LongType.instance).addRegularColumn(OVERLOAD_COUNT, (AbstractType)LongType.instance).addRegularColumn(OVERLOAD_BYTES, (AbstractType)LongType.instance).addRegularColumn(ACTIVE_CONNECTION_COUNT, (AbstractType)LongType.instance).addRegularColumn(CONNECTION_ATTEMPTS, (AbstractType)LongType.instance).addRegularColumn(SUCCESSFUL_CONNECTION_ATTEMPTS, (AbstractType)LongType.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data(DecoratedKey partitionKey) {
        ByteBuffer[] addressAndPortBytes = ((CompositeType)this.metadata().partitionKeyType).split(partitionKey.getKey());
        InetAddress address = (InetAddress)InetAddressType.instance.compose(addressAndPortBytes[0]);
        int port = (Integer)Int32Type.instance.compose(addressAndPortBytes[1]);
        InetAddressAndPort addressAndPort = InetAddressAndPort.getByAddressOverrideDefaults(address, port);
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        OutboundConnections connections = (OutboundConnections)MessagingService.instance().channelManagers.get(addressAndPort);
        if (null != connections) {
            this.addRow(result, addressAndPort, connections);
        }
        return result;
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        MessagingService.instance().channelManagers.forEach((addressAndPort, connections) -> this.addRow(result, (InetAddressAndPort)addressAndPort, (OutboundConnections)connections));
        return result;
    }

    private void addRow(SimpleDataSet dataSet, InetAddressAndPort addressAndPort, OutboundConnections connections) {
        String dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(addressAndPort);
        String rack = DatabaseDescriptor.getEndpointSnitch().getRack(addressAndPort);
        long pendingBytes = InternodeOutboundTable.sum(connections, OutboundConnection::pendingBytes);
        dataSet.row(addressAndPort.address, addressAndPort.port, dc, rack).column(USING_BYTES, pendingBytes).column(USING_RESERVE_BYTES, connections.usingReserveBytes()).column(PENDING_COUNT, InternodeOutboundTable.sum(connections, OutboundConnection::pendingCount)).column(PENDING_BYTES, pendingBytes).column(SENT_COUNT, InternodeOutboundTable.sum(connections, OutboundConnection::sentCount)).column(SENT_BYTES, InternodeOutboundTable.sum(connections, OutboundConnection::sentBytes)).column(EXPIRED_COUNT, InternodeOutboundTable.sum(connections, OutboundConnection::expiredCount)).column(EXPIRED_BYTES, InternodeOutboundTable.sum(connections, OutboundConnection::expiredBytes)).column(ERROR_COUNT, InternodeOutboundTable.sum(connections, OutboundConnection::errorCount)).column(ERROR_BYTES, InternodeOutboundTable.sum(connections, OutboundConnection::errorBytes)).column(OVERLOAD_COUNT, InternodeOutboundTable.sum(connections, OutboundConnection::overloadedCount)).column(OVERLOAD_BYTES, InternodeOutboundTable.sum(connections, OutboundConnection::overloadedBytes)).column(ACTIVE_CONNECTION_COUNT, InternodeOutboundTable.sum(connections, c -> c.isConnected() ? 1L : 0L)).column(CONNECTION_ATTEMPTS, InternodeOutboundTable.sum(connections, OutboundConnection::connectionAttempts)).column(SUCCESSFUL_CONNECTION_ATTEMPTS, InternodeOutboundTable.sum(connections, OutboundConnection::successfulConnections));
    }

    private static long sum(OutboundConnections connections, ToLongFunction<OutboundConnection> f) {
        return f.applyAsLong(connections.small) + f.applyAsLong(connections.large) + f.applyAsLong(connections.urgent);
    }
}

