/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.CommonRange;
import org.apache.cassandra.repair.messages.RepairOption;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemDistributedKeyspace {
    private static final Logger logger = LoggerFactory.getLogger(SystemDistributedKeyspace.class);
    public static final long GENERATION = 5L;
    public static final String REPAIR_HISTORY = "repair_history";
    public static final String PARENT_REPAIR_HISTORY = "parent_repair_history";
    public static final String VIEW_BUILD_STATUS = "view_build_status";
    private static final TableMetadata RepairHistory = SystemDistributedKeyspace.parse("repair_history", "Repair history", "CREATE TABLE %s (keyspace_name text,columnfamily_name text,id timeuuid,parent_id timeuuid,range_begin text,range_end text,coordinator inet,coordinator_port int,participants set<inet>,participants_v2 set<text>,exception_message text,exception_stacktrace text,status text,started_at timestamp,finished_at timestamp,PRIMARY KEY ((keyspace_name, columnfamily_name), id))").defaultTimeToLive((int)TimeUnit.DAYS.toSeconds(30L)).compaction(CompactionParams.twcs((Map<String, String>)ImmutableMap.of((Object)"compaction_window_unit", (Object)"DAYS", (Object)"compaction_window_size", (Object)"1"))).build();
    private static final TableMetadata ParentRepairHistory = SystemDistributedKeyspace.parse("parent_repair_history", "Repair history", "CREATE TABLE %s (parent_id timeuuid,keyspace_name text,columnfamily_names set<text>,started_at timestamp,finished_at timestamp,exception_message text,exception_stacktrace text,requested_ranges set<text>,successful_ranges set<text>,options map<text, text>,PRIMARY KEY (parent_id))").defaultTimeToLive((int)TimeUnit.DAYS.toSeconds(30L)).compaction(CompactionParams.twcs((Map<String, String>)ImmutableMap.of((Object)"compaction_window_unit", (Object)"DAYS", (Object)"compaction_window_size", (Object)"1"))).build();
    private static final TableMetadata ViewBuildStatus = SystemDistributedKeyspace.parse("view_build_status", "Materialized View build status", "CREATE TABLE %s (keyspace_name text,view_name text,host_id uuid,status text,PRIMARY KEY ((keyspace_name, view_name), host_id))").build();

    private SystemDistributedKeyspace() {
    }

    private static TableMetadata.Builder parse(String table, String description, String cql) {
        return CreateTableStatement.parse(String.format(cql, table), "system_distributed").id(TableId.forSystemTable("system_distributed", table)).comment(description);
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create("system_distributed", KeyspaceParams.simple(3), Tables.of(RepairHistory, ParentRepairHistory, ViewBuildStatus));
    }

    public static void startParentRepair(UUID parent_id, String keyspaceName, String[] cfnames, RepairOption options) {
        Collection<Range<Token>> ranges = options.getRanges();
        String query = "INSERT INTO %s.%s (parent_id, keyspace_name, columnfamily_names, requested_ranges, started_at,          options) VALUES (%s,        '%s',          { '%s' },           { '%s' },          toTimestamp(now()), { %s })";
        String fmtQry = String.format(query, "system_distributed", PARENT_REPAIR_HISTORY, parent_id.toString(), keyspaceName, Joiner.on((String)"','").join((Object[])cfnames), Joiner.on((String)"','").join(ranges), SystemDistributedKeyspace.toCQLMap(options.asMap(), "ranges", "columnFamilies"));
        SystemDistributedKeyspace.processSilent(fmtQry, new String[0]);
    }

    private static String toCQLMap(Map<String, String> options, String ... ignore) {
        HashSet toIgnore = Sets.newHashSet((Object[])ignore);
        StringBuilder map = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : options.entrySet()) {
            if (toIgnore.contains(entry.getKey())) continue;
            if (!first) {
                map.append(',');
            }
            first = false;
            map.append(String.format("'%s': '%s'", entry.getKey(), entry.getValue()));
        }
        return map.toString();
    }

    public static void failParentRepair(UUID parent_id, Throwable t) {
        String query = "UPDATE %s.%s SET finished_at = toTimestamp(now()), exception_message=?, exception_stacktrace=? WHERE parent_id=%s";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String fmtQuery = String.format(query, "system_distributed", PARENT_REPAIR_HISTORY, parent_id.toString());
        String message = t.getMessage();
        SystemDistributedKeyspace.processSilent(fmtQuery, message != null ? message : "", sw.toString());
    }

    public static void successfulParentRepair(UUID parent_id, Collection<Range<Token>> successfulRanges) {
        String query = "UPDATE %s.%s SET finished_at = toTimestamp(now()), successful_ranges = {'%s'} WHERE parent_id=%s";
        String fmtQuery = String.format(query, "system_distributed", PARENT_REPAIR_HISTORY, Joiner.on((String)"','").join(successfulRanges), parent_id.toString());
        SystemDistributedKeyspace.processSilent(fmtQuery, new String[0]);
    }

    public static void startRepairs(UUID id, UUID parent_id, String keyspaceName, String[] cfnames, CommonRange commonRange) {
        boolean includeNewColumns = !Gossiper.instance.hasMajorVersion3OrUnknownNodes();
        InetAddressAndPort coordinator = FBUtilities.getBroadcastAddressAndPort();
        HashSet participants = Sets.newHashSet();
        HashSet participants_v2 = Sets.newHashSet();
        for (InetAddressAndPort endpoint : commonRange.endpoints) {
            participants.add(endpoint.getHostAddress(false));
            participants_v2.add(endpoint.getHostAddressAndPort());
        }
        String query = "INSERT INTO %s.%s (keyspace_name, columnfamily_name, id, parent_id, range_begin, range_end, coordinator, coordinator_port, participants, participants_v2, status, started_at) VALUES (   '%s',          '%s',              %s, %s,        '%s',        '%s',      '%s',        %d,               { '%s' },     { '%s' },        '%s',   toTimestamp(now()))";
        String queryWithoutNewColumns = "INSERT INTO %s.%s (keyspace_name, columnfamily_name, id, parent_id, range_begin, range_end, coordinator, participants, status, started_at) VALUES (   '%s',          '%s',              %s, %s,        '%s',        '%s',      '%s',               { '%s' },        '%s',   toTimestamp(now()))";
        for (String cfname : cfnames) {
            for (Range<Token> range : commonRange.ranges) {
                String fmtQry = includeNewColumns ? String.format(query, "system_distributed", REPAIR_HISTORY, keyspaceName, cfname, id.toString(), parent_id.toString(), ((Token)range.left).toString(), ((Token)range.right).toString(), coordinator.getHostAddress(false), coordinator.port, Joiner.on((String)"', '").join((Iterable)participants), Joiner.on((String)"', '").join((Iterable)participants_v2), RepairState.STARTED.toString()) : String.format(queryWithoutNewColumns, "system_distributed", REPAIR_HISTORY, keyspaceName, cfname, id.toString(), parent_id.toString(), ((Token)range.left).toString(), ((Token)range.right).toString(), coordinator.getHostAddress(false), Joiner.on((String)"', '").join((Iterable)participants), RepairState.STARTED.toString());
                SystemDistributedKeyspace.processSilent(fmtQry, new String[0]);
            }
        }
    }

    public static void failRepairs(UUID id, String keyspaceName, String[] cfnames, Throwable t) {
        for (String cfname : cfnames) {
            SystemDistributedKeyspace.failedRepairJob(id, keyspaceName, cfname, t);
        }
    }

    public static void successfulRepairJob(UUID id, String keyspaceName, String cfname) {
        String query = "UPDATE %s.%s SET status = '%s', finished_at = toTimestamp(now()) WHERE keyspace_name = '%s' AND columnfamily_name = '%s' AND id = %s";
        String fmtQuery = String.format(query, "system_distributed", REPAIR_HISTORY, RepairState.SUCCESS.toString(), keyspaceName, cfname, id.toString());
        SystemDistributedKeyspace.processSilent(fmtQuery, new String[0]);
    }

    public static void failedRepairJob(UUID id, String keyspaceName, String cfname, Throwable t) {
        String query = "UPDATE %s.%s SET status = '%s', finished_at = toTimestamp(now()), exception_message=?, exception_stacktrace=? WHERE keyspace_name = '%s' AND columnfamily_name = '%s' AND id = %s";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String fmtQry = String.format(query, "system_distributed", REPAIR_HISTORY, RepairState.FAILED.toString(), keyspaceName, cfname, id.toString());
        SystemDistributedKeyspace.processSilent(fmtQry, t.getMessage(), sw.toString());
    }

    public static void startViewBuild(String keyspace, String view, UUID hostId) {
        String query = "INSERT INTO %s.%s (keyspace_name, view_name, host_id, status) VALUES (?, ?, ?, ?)";
        QueryProcessor.process(String.format(query, "system_distributed", VIEW_BUILD_STATUS), ConsistencyLevel.ONE, Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(keyspace), ByteBufferUtil.bytes(view), ByteBufferUtil.bytes(hostId), ByteBufferUtil.bytes(BuildStatus.STARTED.toString())}));
    }

    public static void successfulViewBuild(String keyspace, String view, UUID hostId) {
        String query = "UPDATE %s.%s SET status = ? WHERE keyspace_name = ? AND view_name = ? AND host_id = ?";
        QueryProcessor.process(String.format(query, "system_distributed", VIEW_BUILD_STATUS), ConsistencyLevel.ONE, Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(BuildStatus.SUCCESS.toString()), ByteBufferUtil.bytes(keyspace), ByteBufferUtil.bytes(view), ByteBufferUtil.bytes(hostId)}));
    }

    public static Map<UUID, String> viewStatus(String keyspace, String view) {
        UntypedResultSet results;
        String query = "SELECT host_id, status FROM %s.%s WHERE keyspace_name = ? AND view_name = ?";
        try {
            results = QueryProcessor.execute(String.format(query, "system_distributed", VIEW_BUILD_STATUS), ConsistencyLevel.ONE, keyspace, view);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
        HashMap<UUID, String> status = new HashMap<UUID, String>();
        for (UntypedResultSet.Row row : results) {
            status.put(row.getUUID("host_id"), row.getString("status"));
        }
        return status;
    }

    public static void setViewRemoved(String keyspaceName, String viewName) {
        String buildReq = "DELETE FROM %s.%s WHERE keyspace_name = ? AND view_name = ?";
        QueryProcessor.executeInternal(String.format(buildReq, "system_distributed", VIEW_BUILD_STATUS), keyspaceName, viewName);
        SystemDistributedKeyspace.forceBlockingFlush(VIEW_BUILD_STATUS);
    }

    private static void processSilent(String fmtQry, String ... values) {
        try {
            ArrayList<ByteBuffer> valueList = new ArrayList<ByteBuffer>(values.length);
            for (String v : values) {
                valueList.add(ByteBufferUtil.bytes(v));
            }
            QueryProcessor.process(fmtQry, ConsistencyLevel.ANY, valueList);
        }
        catch (Throwable t) {
            logger.error("Error executing query " + fmtQry, t);
        }
    }

    public static void forceBlockingFlush(String table) {
        if (!DatabaseDescriptor.isUnsafeSystem()) {
            FBUtilities.waitOnFuture(Keyspace.open("system_distributed").getColumnFamilyStore(table).forceFlush());
        }
    }

    private static enum BuildStatus {
        UNKNOWN,
        STARTED,
        SUCCESS;

    }

    private static enum RepairState {
        STARTED,
        SUCCESS,
        FAILED;

    }
}

