/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.AbstractMutationVerbHandler;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ForwardingInfo;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ParamType;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.MonotonicClock;

public class MutationVerbHandler
extends AbstractMutationVerbHandler<Mutation> {
    public static final MutationVerbHandler instance = new MutationVerbHandler();

    private void respond(Message<?> respondTo, InetAddressAndPort respondToAddress) {
        Tracing.trace("Enqueuing response to {}", (Object)respondToAddress);
        MessagingService.instance().send(respondTo.emptyResponse(), respondToAddress);
    }

    private void failed() {
        Tracing.trace("Payload application resulted in WriteTimeout, not replying");
    }

    @Override
    public void doVerb(Message<Mutation> message) {
        if (MonotonicClock.Global.approxTime.now() > message.expiresAtNanos()) {
            Tracing.trace("Discarding mutation from {} (timed out)", (Object)message.from());
            MessagingService.instance().metrics.recordDroppedMessage(message, message.elapsedSinceCreated(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
            return;
        }
        ((Mutation)message.payload).validateSize(MessagingService.current_version, 12);
        ForwardingInfo forwardTo = message.forwardTo();
        if (forwardTo != null) {
            MutationVerbHandler.forwardToLocalNodes(message, forwardTo);
        }
        InetAddressAndPort respondToAddress = message.respondTo();
        try {
            this.processMessage(message, respondToAddress);
        }
        catch (WriteTimeoutException wto) {
            this.failed();
        }
    }

    @Override
    protected void applyMutation(Message<Mutation> message, InetAddressAndPort respondToAddress) {
        ((Mutation)message.payload).applyFuture().addCallback(o -> this.respond(message, respondToAddress), wto -> this.failed());
    }

    private static void forwardToLocalNodes(Message<Mutation> originalMessage, ForwardingInfo forwardTo) {
        Message.Builder<Mutation> builder = Message.builder(originalMessage).withParam(ParamType.RESPOND_TO, originalMessage.from()).withoutParam(ParamType.FORWARD_TO);
        Message<Mutation> message = builder.build();
        forwardTo.forEach((id, target) -> {
            Tracing.trace("Enqueuing forwarded write to {}", target);
            MessagingService.instance().send(message, (InetAddressAndPort)target);
        });
    }
}

