/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;

final class SSTableTasksTable
extends AbstractVirtualTable {
    private static final String KEYSPACE_NAME = "keyspace_name";
    private static final String TABLE_NAME = "table_name";
    private static final String TASK_ID = "task_id";
    private static final String COMPLETION_RATIO = "completion_ratio";
    private static final String KIND = "kind";
    private static final String PROGRESS = "progress";
    private static final String SSTABLES = "sstables";
    private static final String TOTAL = "total";
    private static final String UNIT = "unit";
    private static final String TARGET_DIRECTORY = "target_directory";

    SSTableTasksTable(String keyspace) {
        super(TableMetadata.builder(keyspace, "sstable_tasks").comment("current sstable tasks").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(KEYSPACE_NAME, UTF8Type.instance).addClusteringColumn(TABLE_NAME, UTF8Type.instance).addClusteringColumn(TASK_ID, TimeUUIDType.instance).addRegularColumn(COMPLETION_RATIO, DoubleType.instance).addRegularColumn(KIND, UTF8Type.instance).addRegularColumn(PROGRESS, LongType.instance).addRegularColumn(SSTABLES, Int32Type.instance).addRegularColumn(TOTAL, LongType.instance).addRegularColumn(UNIT, UTF8Type.instance).addRegularColumn(TARGET_DIRECTORY, UTF8Type.instance).build());
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        for (CompactionInfo task : CompactionManager.instance.getSSTableTasks()) {
            long completed = task.getCompleted();
            long total = task.getTotal();
            double completionRatio = total == 0L ? 1.0 : (double)completed / (double)total;
            result.row(task.getKeyspace().orElse("*"), task.getTable().orElse("*"), task.getTaskId()).column(COMPLETION_RATIO, completionRatio).column(KIND, task.getTaskType().toString().toLowerCase()).column(PROGRESS, completed).column(SSTABLES, task.getSSTables().size()).column(TOTAL, total).column(UNIT, task.getUnit().toString().toLowerCase()).column(TARGET_DIRECTORY, task.targetDirectory());
        }
        return result;
    }
}

