/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.AbstractPaxosRepair;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosRepair;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosTableRepairs
implements AbstractPaxosRepair.Listener {
    private static final Logger logger = LoggerFactory.getLogger(PaxosTableRepairs.class);
    private final Map<DecoratedKey, KeyRepair> keyRepairs = new ConcurrentHashMap<DecoratedKey, KeyRepair>();

    @VisibleForTesting
    KeyRepair getKeyRepairUnsafe(DecoratedKey key) {
        return this.keyRepairs.get(key);
    }

    synchronized AbstractPaxosRepair startOrGetOrQueue(DecoratedKey key, Ballot incompleteBallot, ConsistencyLevel consistency, TableMetadata table, Consumer<AbstractPaxosRepair.Result> onComplete) {
        KeyRepair keyRepair = this.keyRepairs.computeIfAbsent(key, x$0 -> new KeyRepair((DecoratedKey)x$0));
        return keyRepair.startOrGetOrQueue(this, key, incompleteBallot, consistency, table, onComplete);
    }

    @Override
    public synchronized void onComplete(AbstractPaxosRepair repair, AbstractPaxosRepair.Result result) {
        KeyRepair keyRepair = this.keyRepairs.get(repair.partitionKey());
        if (keyRepair == null) {
            NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "onComplete callback fired for nonexistant KeyRepair", new Object[0]);
            return;
        }
        keyRepair.complete(repair);
        if (keyRepair.queueContains(repair)) {
            NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "repair not removed after call to onComplete", new Object[0]);
        }
        if (keyRepair.isEmpty()) {
            this.keyRepairs.remove(repair.partitionKey());
        }
    }

    synchronized void evictHungRepairs(long activeSinceNanos) {
        Predicate<AbstractPaxosRepair> timeoutPredicate = repair -> repair.startedNanos() - activeSinceNanos < 0L;
        for (KeyRepair repair2 : this.keyRepairs.values()) {
            if (repair2.isEmpty()) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, "inactive KeyRepair found, this means post-repair cleanup/schedule isn't working properly", new Object[0]);
            }
            repair2.onFirst(timeoutPredicate, r -> {
                logger.warn("cancelling timed out paxos repair: {}", r);
                r.cancelUnexceptionally();
            }, true);
            repair2.maybeScheduleNext();
            if (!repair2.isEmpty()) continue;
            this.keyRepairs.remove(repair2.key);
        }
    }

    synchronized void clear() {
        for (KeyRepair repair : this.keyRepairs.values()) {
            repair.clear();
        }
        this.keyRepairs.clear();
    }

    @VisibleForTesting
    synchronized boolean hasActiveRepairs(DecoratedKey key) {
        return this.keyRepairs.containsKey(key);
    }

    AbstractPaxosRepair createRepair(DecoratedKey key, Ballot incompleteBallot, ConsistencyLevel consistency, TableMetadata table) {
        return PaxosRepair.create(consistency, key, incompleteBallot, table);
    }

    static class KeyRepair {
        private final DecoratedKey key;
        private final ArrayDeque<AbstractPaxosRepair> queued = new ArrayDeque();

        private KeyRepair(DecoratedKey key) {
            this.key = key;
        }

        void onFirst(Predicate<AbstractPaxosRepair> predicate, Consumer<AbstractPaxosRepair> consumer, boolean removeBeforeAction) {
            while (!this.queued.isEmpty()) {
                AbstractPaxosRepair repair = this.queued.peek();
                if (repair.isComplete()) {
                    this.queued.remove();
                    continue;
                }
                if (predicate.test(repair)) {
                    if (removeBeforeAction) {
                        this.queued.remove();
                    }
                    consumer.accept(repair);
                }
                return;
            }
        }

        void clear() {
            while (!this.queued.isEmpty()) {
                this.queued.remove().cancelUnexceptionally();
            }
        }

        AbstractPaxosRepair startOrGetOrQueue(PaxosTableRepairs tableRepairs, DecoratedKey key, Ballot incompleteBallot, ConsistencyLevel consistency, TableMetadata table, Consumer<AbstractPaxosRepair.Result> onComplete) {
            Preconditions.checkArgument((boolean)this.key.equals(key));
            if (!this.queued.isEmpty() && !Commit.isAfter(incompleteBallot, this.queued.peekLast().incompleteBallot())) {
                this.queued.peekLast().addListener(onComplete);
                return this.queued.peekLast();
            }
            AbstractPaxosRepair repair = tableRepairs.createRepair(key, incompleteBallot, consistency, table);
            repair.addListener(tableRepairs);
            repair.addListener(onComplete);
            this.queued.add(repair);
            this.maybeScheduleNext();
            return repair;
        }

        @VisibleForTesting
        AbstractPaxosRepair activeRepair() {
            return this.queued.peek();
        }

        @VisibleForTesting
        boolean queueContains(AbstractPaxosRepair repair) {
            return this.queued.contains(repair);
        }

        void maybeScheduleNext() {
            this.onFirst(repair -> !repair.isStarted(), AbstractPaxosRepair::start, false);
        }

        void complete(AbstractPaxosRepair repair) {
            this.queued.remove(repair);
            this.maybeScheduleNext();
        }

        int pending() {
            return this.queued.size();
        }

        boolean isEmpty() {
            return this.queued.isEmpty();
        }
    }
}

