/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.service.reads.repair.RepairedDataVerifier;
import org.apache.cassandra.utils.ByteBufferUtil;

public class RepairedDataTracker {
    private final RepairedDataVerifier verifier;
    public final Multimap<ByteBuffer, InetAddressAndPort> digests = HashMultimap.create();
    public final Set<InetAddressAndPort> inconclusiveDigests = new HashSet<InetAddressAndPort>();

    public RepairedDataTracker(RepairedDataVerifier verifier) {
        this.verifier = verifier;
    }

    public void recordDigest(InetAddressAndPort source, ByteBuffer digest, boolean isConclusive) {
        this.digests.put((Object)digest, (Object)source);
        if (!isConclusive) {
            this.inconclusiveDigests.add(source);
        }
    }

    public void verify() {
        this.verifier.verify(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("digests", this.hexDigests()).add("inconclusive", this.inconclusiveDigests).toString();
    }

    private Map<String, Collection<InetAddressAndPort>> hexDigests() {
        HashMap<String, Collection<InetAddressAndPort>> hexDigests = new HashMap<String, Collection<InetAddressAndPort>>();
        this.digests.asMap().forEach((k, v) -> hexDigests.put(ByteBufferUtil.bytesToHex(k), (Collection<InetAddressAndPort>)v));
        return hexDigests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepairedDataTracker that = (RepairedDataTracker)o;
        return Objects.equals(this.digests, that.digests) && Objects.equals(this.inconclusiveDigests, that.inconclusiveDigests);
    }

    public int hashCode() {
        return Objects.hash(this.digests, this.inconclusiveDigests);
    }
}

