/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.Loader;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;

class Janitor {
    private static final int CLEAN_INTERVAL = 32;
    private static final int CLEAN_BATCH_SIZE = 128;
    private static final long CLEAN_TIMEOUT = 1000L;
    private static final String PROP_NSTRIPES = "janitor.stripes";
    private static final int DEFAULT_PROCESSOR_MULTIPLER = 4;
    private final JanitorState state;

    Janitor() {
        this.state = new JanitorState(this);
    }

    Janitor(ThreadFactory threadFactory) {
        this.state = new JanitorState(this, threadFactory);
    }

    Mess register(Object object, Runnable runnable) {
        return this.state.register(object, runnable);
    }

    void wake() {
        this.state.cleaner.interrupt();
    }

    int getStripeCount() {
        return this.state.stripes.length;
    }

    private static final class JanitorState {
        private final int stripeIndexMask;
        private final Stripe[] stripes;
        private final Thread cleaner;

        JanitorState(Janitor janitor) {
            this(janitor, runnable -> {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("Native reference cleanup thread");
                thread.setPriority(8);
                return thread;
            });
        }

        JanitorState(Janitor janitor, ThreadFactory threadFactory) {
            int n = Loader.getProperty(Janitor.PROP_NSTRIPES) != null ? Integer.parseInt(Loader.getProperty(Janitor.PROP_NSTRIPES)) : Runtime.getRuntime().availableProcessors() * 4;
            if (n <= 0) {
                throw new IllegalArgumentException("Bad value for janitor.stripes property; must be positive");
            }
            n = Math.max(1, 2 * Integer.highestOneBit(n - 1));
            this.stripes = new Stripe[n];
            this.stripeIndexMask = this.stripes.length - 1;
            for (int i = 0; i < this.stripes.length; ++i) {
                this.stripes[i] = new Stripe();
            }
            this.stripes[0].add(janitor, () -> {});
            this.cleaner = threadFactory.newThread(this::cleanerThread);
            this.cleaner.start();
        }

        private void cleanerThread() {
            int n = 0;
            while (true) {
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < this.stripes.length; ++i) {
                    if (this.stripes[i].tryClean(false) > 0) {
                        bl = true;
                    }
                    bl2 = bl2 || this.stripes[i].hasOutstandingRefs();
                }
                if (bl) continue;
                if (!bl2) {
                    return;
                }
                if (this.stripes[n].tryClean(true) == 0) {
                    n = n + 1 & this.stripeIndexMask;
                }
                Thread.interrupted();
            }
        }

        private Stripe getStripe() {
            return this.stripes[System.identityHashCode(Thread.currentThread()) & this.stripeIndexMask];
        }

        Mess register(Object object, Runnable runnable) {
            return this.getStripe().add(object, runnable);
        }
    }

    private static final class Stripe {
        private static final AtomicIntegerFieldUpdater<Stripe> F_OBJS_CREATED_SINCE = AtomicIntegerFieldUpdater.newUpdater(Stripe.class, "objectsCreatedSinceLastClean");
        private final ReferenceQueue<Object> queue = new ReferenceQueue();
        private final ReentrantLock queueLock = new ReentrantLock();
        private final HeldReference head = new HeldReference(this.queue, this, () -> {});
        private volatile int objectsCreatedSinceLastClean = 0;
        private long outstandingRefs = 0L;

        Stripe() {
            this.head.prev = (this.head.next = this.head);
        }

        synchronized boolean hasOutstandingRefs() {
            return this.outstandingRefs != 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Mess add(Object object, Runnable runnable) {
            if (F_OBJS_CREATED_SINCE.updateAndGet(this, n -> n >= 31 ? 0 : n + 1) == 0) {
                this.tryClean(false);
            }
            Stripe stripe = this;
            synchronized (stripe) {
                HeldReference heldReference = new HeldReference(object, this, runnable);
                ++this.outstandingRefs;
                heldReference.prev = this.head;
                heldReference.next = this.head.next;
                heldReference.next.prev = heldReference;
                heldReference.prev.next = heldReference;
                return heldReference;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int tryClean(boolean bl) {
            if (bl) {
                this.queueLock.lock();
            } else if (!this.queueLock.tryLock()) {
                return 0;
            }
            try {
                int n;
                for (n = 0; n < 128; ++n) {
                    HeldReference heldReference;
                    try {
                        heldReference = (HeldReference)(bl ? this.queue.remove(1000L) : this.queue.poll());
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        int n2 = n;
                        this.queueLock.unlock();
                        return n2;
                    }
                    if (heldReference == null) {
                        int n3 = n;
                        return n3;
                    }
                    heldReference.clean();
                    bl = false;
                }
                n = 128;
                return n;
            }
            finally {
                this.queueLock.unlock();
            }
        }
    }

    private static final class HeldReference
    extends WeakReference<Object>
    implements Mess {
        private static final AtomicReferenceFieldUpdater<HeldReference, Runnable> F_CLEANER = AtomicReferenceFieldUpdater.newUpdater(HeldReference.class, Runnable.class, "cleaner");
        private final Stripe owningStripe;
        private HeldReference prev;
        private HeldReference next;
        private volatile Runnable cleaner;

        HeldReference(Object object, Stripe stripe, Runnable runnable) {
            super(object, stripe.queue);
            this.owningStripe = stripe;
            this.cleaner = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void clean() {
            Runnable runnable = F_CLEANER.getAndSet(this, null);
            if (runnable == null) {
                return;
            }
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.clear();
            Stripe stripe = this.owningStripe;
            synchronized (stripe) {
                this.owningStripe.outstandingRefs--;
                this.next.prev = this.prev;
                this.prev.next = this.next;
                this.next = this.prev = this;
            }
        }
    }

    static interface Mess {
        public void clean();
    }
}

