/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.config;

import com.google.common.base.Preconditions;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.sparksql.RowBuilder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public interface SchemaFeature {
    public DataType fieldDataType();

    default public void generateDataType(CqlTable table, StructType sparkSchema) {
    }

    public <T extends InternalRow> RowBuilder<T> decorate(RowBuilder<T> var1);

    default public String optionName() {
        return this.fieldName();
    }

    default public StructField field() {
        return new StructField(this.fieldName(), this.fieldDataType(), this.fieldNullable(), this.fieldMetadata());
    }

    default public String fieldName() {
        Preconditions.checkState((boolean)(this instanceof Enum), (Object)"Only implement this interface in enum");
        Enum e = (Enum)((Object)this);
        return e.name().toLowerCase();
    }

    default public boolean fieldNullable() {
        return true;
    }

    default public Metadata fieldMetadata() {
        return Metadata.empty();
    }
}

