/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.types;

import org.apache.cassandra.cql3.functions.types.DataType;
import org.apache.cassandra.cql3.functions.types.SettableByIndexData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.spark.data.NativeType;
import org.apache.cassandra.spark.utils.RandomUtils;

public class Float
extends NativeType {
    public static final Float INSTANCE = new Float();

    public String name() {
        return "float";
    }

    @Override
    public AbstractType<?> dataType() {
        return FloatType.instance;
    }

    @Override
    public Object randomValue(int minCollectionSize) {
        return java.lang.Float.valueOf(RandomUtils.RANDOM.nextFloat());
    }

    @Override
    protected void setInnerValueInternal(SettableByIndexData<?> udtValue, int position, Object value) {
        udtValue.setFloat(position, ((java.lang.Float)value).floatValue());
    }

    @Override
    public DataType driverDataType(boolean isFrozen) {
        return DataType.cfloat();
    }
}

