/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;

public final class TimestampOption
implements Serializable {
    private static final TimestampOption NOW = new TimestampOption(System.currentTimeMillis() * 1000L);
    private String timestampColumnName;
    private Long timeStampInMicroSeconds;

    private TimestampOption(String timestampColumnName) {
        this.timestampColumnName = timestampColumnName;
    }

    private TimestampOption(Long timeStampInMicroSeconds) {
        this.timeStampInMicroSeconds = timeStampInMicroSeconds;
    }

    public static TimestampOption from(String timestamp) {
        if (timestamp == null) {
            return NOW;
        }
        try {
            return new TimestampOption(Long.parseLong(timestamp));
        }
        catch (Exception e) {
            return new TimestampOption(timestamp);
        }
    }

    public static String constant(long timestampInMicroSeconds) {
        return String.valueOf(timestampInMicroSeconds);
    }

    public static String constant(Duration duration) {
        return String.valueOf(duration.get(ChronoUnit.MICROS));
    }

    public static String perRow(String timeStampColumnName) {
        return timeStampColumnName;
    }

    public static TimestampOption now() {
        return NOW;
    }

    public String columnName() {
        return this.timestampColumnName;
    }

    public boolean withTimestamp() {
        return !this.equals(NOW) && (this.timestampColumnName != null || this.timeStampInMicroSeconds != null);
    }

    public String toCQLString(Function<String, String> maybeQuoteFunction) {
        if (this.timestampColumnName != null && !this.timestampColumnName.isEmpty()) {
            return ":" + maybeQuoteFunction.apply(this.timestampColumnName);
        }
        if (this.timeStampInMicroSeconds != null) {
            return Long.toString(this.timeStampInMicroSeconds);
        }
        return null;
    }
}

