/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.bridge.SSTableSummary;

public class BundleManifest
extends HashMap<String, Entry> {
    public static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final long serialVersionUID = 6593130321276240266L;

    public void addEntry(Entry manifestEntry) {
        super.put(manifestEntry.key, manifestEntry);
    }

    public void persistTo(Path filePath) throws IOException {
        Files.createFile(filePath, new FileAttribute[0]);
        OBJECT_WRITER.writeValue(filePath.toFile(), (Object)this);
    }

    public static class Entry {
        private final String key;
        private final Map<String, String> componentsChecksum;
        private final BigInteger firstToken;
        private final BigInteger endToken;

        @VisibleForTesting
        Entry(String key, BigInteger firstToken, BigInteger endToken) {
            this.key = key;
            this.firstToken = firstToken;
            this.endToken = endToken;
            this.componentsChecksum = new HashMap<String, String>();
        }

        public Entry(SSTableSummary summary) {
            this.key = summary.sstableId;
            this.firstToken = summary.firstToken;
            this.endToken = summary.lastToken;
            this.componentsChecksum = new HashMap<String, String>();
        }

        public void addComponentChecksum(String component, String checksum) {
            this.componentsChecksum.put(component, checksum);
        }

        @JsonProperty(value="components_checksum")
        public Map<String, String> componentsChecksum() {
            return this.componentsChecksum;
        }

        @JsonProperty(value="start_token")
        public BigInteger firstToken() {
            return this.firstToken;
        }

        @JsonProperty(value="end_token")
        public BigInteger endToken() {
            return this.endToken;
        }
    }
}

