/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.cassandra.spark.bulkwriter.CancelJobEvent;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.token.TokenRangeMapping;
import org.apache.cassandra.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraTopologyMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraTopologyMonitor.class);
    private static final long PERIODIC_CHECK_DELAY_MS = 5000L;
    private static final long MAX_CHECK_ATTEMPTS = 10L;
    private final ClusterInfo clusterInfo;
    private final TokenRangeMapping<RingInstance> initialTopology;
    private final ScheduledExecutorService executorService;
    private final Consumer<CancelJobEvent> onCancelJob;
    private int retryCount = 0;
    private volatile boolean isStopped = false;

    public CassandraTopologyMonitor(ClusterInfo clusterInfo, Consumer<CancelJobEvent> onCancelJob) {
        this.clusterInfo = clusterInfo;
        this.onCancelJob = onCancelJob.andThen(e -> {
            this.isStopped = true;
        });
        this.initialTopology = clusterInfo.getTokenRangeMapping(false);
        this.executorService = Executors.newSingleThreadScheduledExecutor(ThreadUtil.threadFactory((String)"Cassandra Topology Monitor"));
        this.executorService.scheduleWithFixedDelay(this::checkTopology, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    public TokenRangeMapping<RingInstance> initialTopology() {
        return this.initialTopology;
    }

    private void checkTopology() {
        if (this.isStopped) {
            LOGGER.info("Already stopped. Skip checking topology");
            return;
        }
        LOGGER.debug("Checking topology");
        try {
            TokenRangeMapping<RingInstance> currentTopology = this.clusterInfo.getTokenRangeMapping(false);
            if (!currentTopology.equals(this.initialTopology)) {
                this.onCancelJob.accept(new CancelJobEvent("Topology changed during bulk write"));
                return;
            }
            this.retryCount = 0;
        }
        catch (Exception exception) {
            if ((long)this.retryCount++ > 10L) {
                LOGGER.error("Could not retrieve current topology. All hosts exhausted. The retrieval has failed consecutive for {} times", (Object)this.retryCount);
                this.onCancelJob.accept(new CancelJobEvent("Could not retrieve current cassandra topology. All hosts and retries have been exhausted.", exception));
            }
            LOGGER.warn("Could not retrieve current topology. Will retry momentarily. Continuing bulk write.", (Throwable)exception);
        }
    }

    @VisibleForTesting
    void checkTopologyOnDemand() {
        this.checkTopology();
    }
}

