/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.client.SidecarInstanceImpl;
import o.a.c.sidecar.client.shaded.common.response.RingResponse;
import o.a.c.sidecar.client.shaded.common.response.TableStatsResponse;
import o.a.c.sidecar.client.shaded.common.response.data.RingEntry;
import org.apache.cassandra.spark.data.TableSizeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarTableSizeProvider
implements TableSizeProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SidecarTableSizeProvider.class);
    private final SidecarClient sidecarClient;
    private final int sidecarPort;
    private final CompletableFuture<RingResponse> ringFuture;

    public SidecarTableSizeProvider(SidecarClient sidecarClient, int sidecarPort, CompletableFuture<RingResponse> ringFuture) {
        this.sidecarClient = sidecarClient;
        this.sidecarPort = sidecarPort;
        this.ringFuture = ringFuture;
    }

    public long tableSizeInBytes(String keyspace, String table, String datacenter) {
        try {
            RingResponse ringResponse = this.ringFuture.toCompletableFuture().get();
            return this.tableSizeInBytesInternal(ringResponse, keyspace, table, datacenter);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Error occurred while determining the table size for table '%s.%s'", keyspace, table), ex);
        }
    }

    private long tableSizeInBytesInternal(RingResponse ringResponse, String keyspace, String table, String datacenter) {
        LongAdder tableSize = new LongAdder();
        LongAdder success = new LongAdder();
        List instances = ringResponse.stream().filter(ringEntry -> datacenter == null || datacenter.equals(ringEntry.datacenter())).collect(Collectors.toUnmodifiableList());
        int instancesSize = instances.size();
        CountDownLatch latch = new CountDownLatch(instancesSize);
        for (RingEntry ringEntry2 : instances) {
            SidecarInstanceImpl sidecarInstance = new SidecarInstanceImpl(ringEntry2.fqdn(), this.sidecarPort);
            CompletableFuture tableStatsResponseCompletableFuture = this.sidecarClient.tableStats((SidecarInstance)sidecarInstance, keyspace, table);
            tableStatsResponseCompletableFuture.whenComplete((arg_0, arg_1) -> SidecarTableSizeProvider.lambda$tableSizeInBytesInternal$1(tableSize, success, keyspace, table, (SidecarInstance)sidecarInstance, latch, arg_0, arg_1));
        }
        SidecarTableSizeProvider.await(latch);
        long successCount = success.sum();
        long tableSizeSum = tableSize.sum();
        if (successCount == 0L) {
            throw new RuntimeException(String.format("Unable to determine the table size for table '%s.%s'. 0/%d instances available.", keyspace, table, instancesSize));
        }
        if (successCount < (long)instancesSize) {
            LOGGER.info("{}/{} instances were used to determine the table size {} for table {}.{}", new Object[]{successCount, instancesSize, tableSizeSum, keyspace, table});
            return tableSizeSum / successCount * (long)instancesSize;
        }
        return tableSizeSum;
    }

    static void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$tableSizeInBytesInternal$1(LongAdder tableSize, LongAdder success, String keyspace, String table, SidecarInstance sidecarInstance, CountDownLatch latch, TableStatsResponse response, Throwable throwable) {
        try {
            if (throwable == null) {
                tableSize.add(response.totalDiskSpaceUsedBytes());
                success.increment();
            } else {
                LOGGER.warn("Failed to retrieve table statistics for keyspace {} table {} on instance {}", new Object[]{keyspace, table, sidecarInstance, throwable});
            }
        }
        finally {
            latch.countDown();
        }
    }
}

