/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.retry;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.exception.RetriesExhaustedException;
import org.apache.cassandra.sidecar.client.retry.RetryAction;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.common.request.Request;

public class NoRetryPolicy
extends RetryPolicy {
    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (throwable != null) {
            responseFuture.completeExceptionally(RetriesExhaustedException.of(attempts, request, response));
        } else if (response.statusCode() == HttpResponseStatus.OK.code()) {
            responseFuture.complete(response);
        } else {
            responseFuture.completeExceptionally(RetriesExhaustedException.of(attempts, request, response));
        }
    }
}

