/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.replacement;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.analytics.TestUninterruptibles;
import org.apache.cassandra.analytics.replacement.HostReplacementTestBase;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.spark.bulkwriter.WriterOptions;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class HostReplacementTest
extends HostReplacementTestBase {
    HostReplacementTest() {
    }

    @ParameterizedTest(name="{index} => {0}")
    @MethodSource(value={"singleDCTestInputs"})
    void testHostReplacement(TestConsistencyLevel cl) {
        QualifiedName table = HostReplacementTest.uniqueTestTableFullName("spark_test", cl.readCL, cl.writeCL);
        this.bulkWriterDataFrameWriter((Dataset<Row>)this.df, table).option(WriterOptions.BULK_WRITER_CL.name(), cl.writeCL.name()).save();
    }

    protected void beforeClusterShutdown() {
        this.completeTransitionsAndValidateWrites(BBHelperReplacementsNode.transitioningStateEnd, HostReplacementTest.singleDCTestInputs(), false);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3);
        HostReplacementTest.singleDCTestInputs().forEach(arguments -> {
            QualifiedName tableName = HostReplacementTest.uniqueTestTableFullName("spark_test", arguments.get());
            this.createTestTable(tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return HostReplacementTest.clusterConfig().nodesPerDc(5).newNodesPerDc(1).requestFeature(Feature.NETWORK).instanceInitializer(BBHelperReplacementsNode::install);
    }

    @Override
    protected CountDownLatch nodeStart() {
        return BBHelperReplacementsNode.nodeStart;
    }

    public static class BBHelperReplacementsNode {
        static final CountDownLatch nodeStart = new CountDownLatch(1);
        static final CountDownLatch transitioningStateStart = new CountDownLatch(1);
        static final CountDownLatch transitioningStateEnd = new CountDownLatch(1);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber == 6) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.StorageService").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"bootstrap").and((ElementMatcher)ElementMatchers.takesArguments((int)2))).intercept((Implementation)MethodDelegation.to(BBHelperReplacementsNode.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static boolean bootstrap(Collection<?> tokens, long bootstrapTimeoutMillis, @SuperCall Callable<Boolean> orig) throws Exception {
            boolean result = orig.call();
            nodeStart.countDown();
            transitioningStateStart.countDown();
            TestUninterruptibles.awaitUninterruptiblyOrThrow(transitioningStateEnd, 2L, TimeUnit.MINUTES);
            return result;
        }
    }
}

