/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

public interface Term {
    public void collectMarkerSpecification(VariableSpecifications var1);

    public Terminal bind(QueryOptions var1) throws InvalidRequestException;

    public ByteBuffer bindAndGet(QueryOptions var1) throws InvalidRequestException;

    public boolean containsBindMarker();

    default public boolean isTerminal() {
        return false;
    }

    public void addFunctionsTo(List<Function> var1);

    public static abstract class NonTerminal
    implements Term {
        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            Terminal t2 = this.bind(options);
            return t2 == null ? null : t2.get(options.getProtocolVersion());
        }
    }

    public static abstract class MultiItemTerminal
    extends Terminal {
        public abstract List<ByteBuffer> getElements();
    }

    public static abstract class Terminal
    implements Term {
        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
        }

        @Override
        public Terminal bind(QueryOptions options) {
            return this;
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
        }

        @Override
        public boolean containsBindMarker() {
            return false;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        public abstract ByteBuffer get(ProtocolVersion var1) throws InvalidRequestException;

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            return this.get(options.getProtocolVersion());
        }
    }

    public static abstract class MultiColumnRaw
    extends Raw {
        public abstract Term prepare(String var1, List<? extends ColumnSpecification> var2) throws InvalidRequestException;
    }

    public static abstract class Raw
    implements AssignmentTestable {
        public abstract Term prepare(String var1, ColumnSpecification var2) throws InvalidRequestException;

        public abstract String getText();

        public abstract AbstractType<?> getExactTypeIfKnown(String var1);

        @Override
        public AbstractType<?> getCompatibleTypeIfKnown(String keyspace) {
            return this.getExactTypeIfKnown(keyspace);
        }

        public String toString() {
            return this.getText();
        }

        public int hashCode() {
            return this.getText().hashCode();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Raw && this.getText().equals(((Raw)o).getText());
        }
    }
}

