/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.conditions.ColumnCondition;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CQL3CasRequest
implements CASRequest {
    public final TableMetadata metadata;
    public final DecoratedKey key;
    private final RegularAndStaticColumns conditionColumns;
    private final boolean updatesRegularRows;
    private final boolean updatesStaticRow;
    private boolean hasExists;
    private RowCondition staticConditions;
    private final TreeMap<Clustering<?>, RowCondition> conditions;
    private final List<RowUpdate> updates = new ArrayList<RowUpdate>();
    private final List<RangeDeletion> rangeDeletions = new ArrayList<RangeDeletion>();

    public CQL3CasRequest(TableMetadata metadata, DecoratedKey key, RegularAndStaticColumns conditionColumns, boolean updatesRegularRows, boolean updatesStaticRow) {
        this.metadata = metadata;
        this.key = key;
        this.conditions = new TreeMap(metadata.comparator);
        this.conditionColumns = conditionColumns;
        this.updatesRegularRows = updatesRegularRows;
        this.updatesStaticRow = updatesStaticRow;
    }

    void addRowUpdate(Clustering<?> clustering, ModificationStatement stmt, QueryOptions options, long timestamp, long nowInSeconds) {
        this.updates.add(new RowUpdate(clustering, stmt, options, timestamp, nowInSeconds));
    }

    void addRangeDeletion(Slice slice, ModificationStatement stmt, QueryOptions options, long timestamp, long nowInSeconds) {
        this.rangeDeletions.add(new RangeDeletion(slice, stmt, options, timestamp, nowInSeconds));
    }

    public void addNotExist(Clustering<?> clustering) throws InvalidRequestException {
        this.addExistsCondition(clustering, new NotExistCondition(clustering), true);
    }

    public void addExist(Clustering<?> clustering) throws InvalidRequestException {
        this.addExistsCondition(clustering, new ExistCondition(clustering), false);
    }

    private void addExistsCondition(Clustering<?> clustering, RowCondition condition, boolean isNotExist) {
        assert (condition instanceof ExistCondition || condition instanceof NotExistCondition);
        RowCondition previous = this.getConditionsForRow(clustering);
        if (previous != null) {
            if (previous.getClass().equals(condition.getClass())) {
                assert (this.hasExists);
                return;
            }
            throw previous instanceof NotExistCondition || previous instanceof ExistCondition ? new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row") : new InvalidRequestException("Cannot mix IF conditions and IF " + (isNotExist ? "NOT " : "") + "EXISTS for the same row");
        }
        this.setConditionsForRow(clustering, condition);
        this.hasExists = true;
    }

    public void addConditions(Clustering<?> clustering, Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
        RowCondition condition = this.getConditionsForRow(clustering);
        if (condition == null) {
            condition = new ColumnsConditions(clustering);
            this.setConditionsForRow(clustering, condition);
        } else if (!(condition instanceof ColumnsConditions)) {
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
        ((ColumnsConditions)condition).addConditions(conds, options);
    }

    private RowCondition getConditionsForRow(Clustering<?> clustering) {
        return clustering == Clustering.STATIC_CLUSTERING ? this.staticConditions : this.conditions.get(clustering);
    }

    private void setConditionsForRow(Clustering<?> clustering, RowCondition condition) {
        if (clustering == Clustering.STATIC_CLUSTERING) {
            assert (this.staticConditions == null);
            this.staticConditions = condition;
        } else {
            RowCondition previous = this.conditions.put(clustering, condition);
            assert (previous == null);
        }
    }

    private RegularAndStaticColumns columnsToRead() {
        RegularAndStaticColumns allColumns = this.metadata.regularAndStaticColumns();
        Columns statics = this.updatesStaticRow ? allColumns.statics : this.conditionColumns.statics;
        Columns regulars = this.updatesRegularRows ? allColumns.regulars : this.conditionColumns.regulars;
        return new RegularAndStaticColumns(statics, regulars);
    }

    @Override
    public SinglePartitionReadCommand readCommand(long nowInSec) {
        assert (this.staticConditions != null || !this.conditions.isEmpty());
        ColumnFilter columnFilter = ColumnFilter.selection(this.columnsToRead());
        if (this.conditions.isEmpty()) {
            return SinglePartitionReadCommand.create(this.metadata, nowInSec, columnFilter, RowFilter.none(), DataLimits.cqlLimits(1), this.key, new ClusteringIndexSliceFilter(Slices.ALL, false));
        }
        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(this.conditions.navigableKeySet(), false);
        return SinglePartitionReadCommand.create(this.metadata, nowInSec, this.key, columnFilter, filter);
    }

    @Override
    public boolean appliesTo(FilteredPartition current) throws InvalidRequestException {
        if (this.staticConditions != null && !this.staticConditions.appliesTo(current)) {
            return false;
        }
        for (RowCondition condition : this.conditions.values()) {
            if (condition.appliesTo(current)) continue;
            return false;
        }
        return true;
    }

    private RegularAndStaticColumns updatedColumns() {
        RegularAndStaticColumns.Builder builder = RegularAndStaticColumns.builder();
        for (RowUpdate upd : this.updates) {
            builder.addAll(upd.stmt.updatedColumns());
        }
        return builder.build();
    }

    @Override
    public PartitionUpdate makeUpdates(FilteredPartition current, ClientState clientState, Ballot ballot) throws InvalidRequestException {
        PartitionUpdate.Builder updateBuilder = new PartitionUpdate.Builder(this.metadata, this.key, this.updatedColumns(), this.conditions.size());
        long timeUuidNanos = 0L;
        for (RowUpdate rowUpdate : this.updates) {
            timeUuidNanos = rowUpdate.applyUpdates(current, updateBuilder, clientState, ballot.msb(), timeUuidNanos);
        }
        for (RangeDeletion rangeDeletion : this.rangeDeletions) {
            rangeDeletion.applyUpdates(current, updateBuilder, clientState);
        }
        PartitionUpdate partitionUpdate = updateBuilder.build();
        IndexRegistry.obtain(this.metadata).validate(partitionUpdate, clientState);
        return partitionUpdate;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static class ColumnsConditions
    extends RowCondition {
        private final Multimap<Pair<ColumnIdentifier, ByteBuffer>, ColumnCondition.Bound> conditions = HashMultimap.create();

        private ColumnsConditions(Clustering<?> clustering) {
            super(clustering);
        }

        public void addConditions(Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
            for (ColumnCondition condition : conds) {
                ColumnCondition.Bound current = condition.bind(options);
                this.conditions.put(Pair.create(condition.column.name, current.getCollectionElementValue()), current);
            }
        }

        @Override
        public boolean appliesTo(FilteredPartition current) throws InvalidRequestException {
            Row row = current.getRow(this.clustering);
            for (ColumnCondition.Bound condition : this.conditions.values()) {
                if (condition.appliesTo(row)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExistCondition
    extends RowCondition {
        private ExistCondition(Clustering<?> clustering) {
            super(clustering);
        }

        @Override
        public boolean appliesTo(FilteredPartition current) {
            return current.getRow(this.clustering) != null;
        }
    }

    private static class NotExistCondition
    extends RowCondition {
        private NotExistCondition(Clustering<?> clustering) {
            super(clustering);
        }

        @Override
        public boolean appliesTo(FilteredPartition current) {
            return current.getRow(this.clustering) == null;
        }
    }

    private static abstract class RowCondition {
        public final Clustering<?> clustering;

        protected RowCondition(Clustering<?> clustering) {
            this.clustering = clustering;
        }

        public abstract boolean appliesTo(FilteredPartition var1) throws InvalidRequestException;
    }

    private class RangeDeletion {
        private final Slice slice;
        private final ModificationStatement stmt;
        private final QueryOptions options;
        private final long timestamp;
        private final long nowInSeconds;

        private RangeDeletion(Slice slice, ModificationStatement stmt, QueryOptions options, long timestamp, long nowInSeconds) {
            this.slice = slice;
            this.stmt = stmt;
            this.options = options;
            this.timestamp = timestamp;
            this.nowInSeconds = nowInSeconds;
        }

        void applyUpdates(FilteredPartition current, PartitionUpdate.Builder updateBuilder, ClientState state) {
            Map<DecoratedKey, Partition> map = this.stmt.requiresRead() ? Collections.singletonMap(CQL3CasRequest.this.key, current) : null;
            UpdateParameters params = new UpdateParameters(CQL3CasRequest.this.metadata, updateBuilder.columns(), state, this.options, this.timestamp, this.nowInSeconds, this.stmt.getTimeToLive(this.options), map);
            this.stmt.addUpdateForKey(updateBuilder, this.slice, params);
        }
    }

    private class RowUpdate {
        private final Clustering<?> clustering;
        private final ModificationStatement stmt;
        private final QueryOptions options;
        private final long timestamp;
        private final long nowInSeconds;

        private RowUpdate(Clustering<?> clustering, ModificationStatement stmt, QueryOptions options, long timestamp, long nowInSeconds) {
            this.clustering = clustering;
            this.stmt = stmt;
            this.options = options;
            this.timestamp = timestamp;
            this.nowInSeconds = nowInSeconds;
        }

        long applyUpdates(FilteredPartition current, PartitionUpdate.Builder updateBuilder, ClientState state, long timeUuidMsb, long timeUuidNanos) {
            Map<DecoratedKey, Partition> map = this.stmt.requiresRead() ? Collections.singletonMap(CQL3CasRequest.this.key, current) : null;
            CASUpdateParameters params = new CASUpdateParameters(CQL3CasRequest.this.metadata, updateBuilder.columns(), state, this.options, this.timestamp, this.nowInSeconds, this.stmt.getTimeToLive(this.options), map, timeUuidMsb, timeUuidNanos);
            this.stmt.addUpdateForKey(updateBuilder, this.clustering, (UpdateParameters)params);
            return params.timeUuidNanos;
        }
    }

    private static class CASUpdateParameters
    extends UpdateParameters {
        final long timeUuidMsb;
        long timeUuidNanos;

        public CASUpdateParameters(TableMetadata metadata, RegularAndStaticColumns updatedColumns, ClientState state, QueryOptions options, long timestamp, long nowInSec, int ttl, Map<DecoratedKey, Partition> prefetchedRows, long timeUuidMsb, long timeUuidNanos) throws InvalidRequestException {
            super(metadata, updatedColumns, state, options, timestamp, nowInSec, ttl, prefetchedRows);
            this.timeUuidMsb = timeUuidMsb;
            this.timeUuidNanos = timeUuidNanos;
        }

        @Override
        public byte[] nextTimeUUIDAsBytes() {
            return TimeUUID.toBytes(this.timeUuidMsb, TimeUUIDType.signedBytesToNativeLong(this.timeUuidNanos++));
        }
    }
}

