/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.Optional;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.ArtificialBoundMarker;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.LazilyInitializedUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReadsListener;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.keycache.KeyCacheSupport;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.IteratorWithLowerBound;

public class UnfilteredRowIteratorWithLowerBound
extends LazilyInitializedUnfilteredRowIterator
implements IteratorWithLowerBound<Unfiltered> {
    private final SSTableReader sstable;
    private final Slices slices;
    private final boolean isReverseOrder;
    private final ColumnFilter selectedColumns;
    private final SSTableReadsListener listener;
    private Optional<Unfiltered> lowerBoundMarker;
    private boolean firstItemRetrieved;

    public UnfilteredRowIteratorWithLowerBound(DecoratedKey partitionKey, SSTableReader sstable, ClusteringIndexFilter filter, ColumnFilter selectedColumns, SSTableReadsListener listener) {
        this(partitionKey, sstable, filter.getSlices(sstable.metadata()), filter.isReversed(), selectedColumns, listener);
    }

    @VisibleForTesting
    public UnfilteredRowIteratorWithLowerBound(DecoratedKey partitionKey, SSTableReader sstable, Slices slices, boolean isReverseOrder, ColumnFilter selectedColumns, SSTableReadsListener listener) {
        super(partitionKey);
        this.sstable = sstable;
        this.slices = slices;
        this.isReverseOrder = isReverseOrder;
        this.selectedColumns = selectedColumns;
        this.listener = listener;
        this.firstItemRetrieved = false;
    }

    @Override
    public Unfiltered lowerBound() {
        if (this.lowerBoundMarker != null) {
            return this.lowerBoundMarker.orElse(null);
        }
        ClusteringBound<?> lowerBound = this.maybeGetLowerBoundFromKeyCache();
        if (lowerBound == null) {
            lowerBound = this.maybeGetLowerBoundFromMetadata();
        }
        this.lowerBoundMarker = lowerBound != null ? Optional.of(this.makeBound(lowerBound)) : Optional.empty();
        return this.lowerBoundMarker.orElse(null);
    }

    private Unfiltered makeBound(ClusteringBound<?> bound) {
        if (bound == null) {
            return null;
        }
        return new ArtificialBoundMarker(bound);
    }

    @Override
    protected UnfilteredRowIterator initializeIterator() {
        UnfilteredRowIterator iter2 = RTBoundValidator.validate(this.sstable.rowIterator(this.partitionKey(), this.slices, this.selectedColumns, this.isReverseOrder, this.listener), RTBoundValidator.Stage.SSTABLE, false);
        return iter2;
    }

    @Override
    protected Unfiltered computeNext() {
        Unfiltered ret = super.computeNext();
        if (this.firstItemRetrieved) {
            return ret;
        }
        this.firstItemRetrieved = true;
        Unfiltered lowerBound = this.lowerBound();
        if (lowerBound != null && ret != null) assert (this.comparator().compare(lowerBound.clustering(), ret.clustering()) <= 0) : String.format("Lower bound [%s ]is bigger than first returned value [%s] for sstable %s", lowerBound.clustering().toString(this.metadata()), ret.toString(this.metadata()), this.sstable.getFilename());
        return ret;
    }

    private Comparator<Clusterable> comparator() {
        return this.isReverseOrder ? this.metadata().comparator.reversed() : this.metadata().comparator;
    }

    @Override
    public TableMetadata metadata() {
        return this.sstable.metadata();
    }

    @Override
    public boolean isReverseOrder() {
        return this.isReverseOrder;
    }

    @Override
    public RegularAndStaticColumns columns() {
        return this.selectedColumns.fetchedColumns();
    }

    @Override
    public EncodingStats stats() {
        return this.sstable.stats();
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        if (!this.sstable.getSSTableMetadata().hasPartitionLevelDeletions) {
            return DeletionTime.LIVE;
        }
        return super.partitionLevelDeletion();
    }

    @Override
    public Row staticRow() {
        if (this.columns().statics.isEmpty()) {
            return Rows.EMPTY_STATIC_ROW;
        }
        return super.staticRow();
    }

    private ClusteringBound<?> maybeGetLowerBoundFromKeyCache() {
        if (this.sstable instanceof KeyCacheSupport) {
            return ((KeyCacheSupport)((Object)this.sstable)).getLowerBoundPrefixFromCache(this.partitionKey(), this.isReverseOrder);
        }
        return null;
    }

    private boolean canUseMetadataLowerBound() {
        if (this.sstable.metadata().isCompactTable()) {
            return false;
        }
        Slices requestedSlices = this.slices;
        if (requestedSlices.isEmpty()) {
            return true;
        }
        if (!this.isReverseOrder()) {
            return !requestedSlices.hasLowerBound() || this.metadata().comparator.compare(requestedSlices.start(), this.sstable.getSSTableMetadata().coveredClustering.start()) < 0;
        }
        return !requestedSlices.hasUpperBound() || this.metadata().comparator.compare(requestedSlices.end(), this.sstable.getSSTableMetadata().coveredClustering.end()) > 0;
    }

    private ClusteringBound<?> maybeGetLowerBoundFromMetadata() {
        if (!this.canUseMetadataLowerBound()) {
            return null;
        }
        StatsMetadata m4 = this.sstable.getSSTableMetadata();
        ClusteringBound<?> bound = m4.coveredClustering.open(this.isReverseOrder);
        UnfilteredRowIteratorWithLowerBound.assertBoundSize(bound, this.sstable);
        return bound.artificialLowerBound(this.isReverseOrder);
    }

    public static void assertBoundSize(ClusteringPrefix<?> lowerBound, SSTable sstable) {
        assert (lowerBound.size() <= sstable.metadata().comparator.size()) : String.format("Unexpected number of clustering values %d, expected %d or fewer for %s", lowerBound.size(), sstable.metadata().comparator.size(), sstable.getFilename());
    }
}

