/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.tries.InMemoryTrie;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.PerColumnIndexWriter;
import org.apache.cassandra.index.sai.disk.PerSSTableIndexWriter;
import org.apache.cassandra.index.sai.disk.RowMapping;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.sstable.SSTableFlushObserver;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class StorageAttachedIndexWriter
implements SSTableFlushObserver {
    private static final Logger logger = LoggerFactory.getLogger(StorageAttachedIndexWriter.class);
    private final IndexDescriptor indexDescriptor;
    private final Collection<PerColumnIndexWriter> perIndexWriters;
    private final PerSSTableIndexWriter perSSTableWriter;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final RowMapping rowMapping;
    private final long nowInSeconds = FBUtilities.nowInSeconds();
    private DecoratedKey currentKey;
    private boolean tokenOffsetWriterCompleted = false;
    private boolean aborted = false;
    private long sstableRowId = 0L;

    public static StorageAttachedIndexWriter createFlushObserverWriter(IndexDescriptor indexDescriptor, Collection<StorageAttachedIndex> indexes, LifecycleNewTracker lifecycleNewTracker) throws IOException {
        return new StorageAttachedIndexWriter(indexDescriptor, indexes, lifecycleNewTracker, false);
    }

    public static StorageAttachedIndexWriter createBuilderWriter(IndexDescriptor indexDescriptor, Collection<StorageAttachedIndex> indexes, LifecycleNewTracker lifecycleNewTracker, boolean perIndexComponentsOnly) throws IOException {
        return new StorageAttachedIndexWriter(indexDescriptor, indexes, lifecycleNewTracker, perIndexComponentsOnly);
    }

    private StorageAttachedIndexWriter(IndexDescriptor indexDescriptor, Collection<StorageAttachedIndex> indexes, LifecycleNewTracker lifecycleNewTracker, boolean perIndexComponentsOnly) throws IOException {
        this.indexDescriptor = indexDescriptor;
        this.rowMapping = RowMapping.create(lifecycleNewTracker.opType());
        this.perIndexWriters = indexes.stream().map(index -> indexDescriptor.newPerColumnIndexWriter((StorageAttachedIndex)index, lifecycleNewTracker, this.rowMapping)).filter(Objects::nonNull).collect(Collectors.toList());
        this.perSSTableWriter = perIndexComponentsOnly ? PerSSTableIndexWriter.NONE : indexDescriptor.newPerSSTableIndexWriter();
    }

    @Override
    public void begin() {
        logger.debug(this.indexDescriptor.logMessage("Starting partition iteration for storage-attached index flush for SSTable {}..."), (Object)this.indexDescriptor.sstableDescriptor);
        this.stopwatch.start();
    }

    @Override
    public void startPartition(DecoratedKey key, long keyPosition, long keyPositionForSASI) {
        if (this.aborted) {
            return;
        }
        this.currentKey = key;
        try {
            this.perSSTableWriter.startPartition(key);
        }
        catch (Throwable t2) {
            logger.error(this.indexDescriptor.logMessage("Failed to record a partition during an index build"), t2);
            this.abort(t2, true);
        }
    }

    @Override
    public void nextUnfilteredCluster(Unfiltered unfiltered) {
        if (this.aborted) {
            return;
        }
        if (!unfiltered.isRow()) {
            return;
        }
        Row row = (Row)unfiltered;
        if (!row.hasLiveData(this.nowInSeconds, false)) {
            return;
        }
        try {
            this.addRow(row);
        }
        catch (Throwable t2) {
            logger.error(this.indexDescriptor.logMessage("Failed to record a row during an index build"), t2);
            this.abort(t2, true);
        }
    }

    @Override
    public void staticRow(Row staticRow) {
        if (this.aborted) {
            return;
        }
        if (staticRow.isEmpty()) {
            return;
        }
        try {
            this.addRow(staticRow);
        }
        catch (Throwable t2) {
            logger.error(this.indexDescriptor.logMessage("Failed to record a static row during an index build"), t2);
            this.abort(t2, true);
        }
    }

    @Override
    public void complete() {
        if (this.aborted) {
            return;
        }
        long start = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        logger.debug(this.indexDescriptor.logMessage("Completed partition iteration for index flush for SSTable {}. Elapsed time: {} ms"), (Object)this.indexDescriptor.sstableDescriptor, (Object)start);
        try {
            this.perSSTableWriter.complete();
            this.tokenOffsetWriterCompleted = true;
            long elapsed = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            logger.debug(this.indexDescriptor.logMessage("Completed per-SSTable write for SSTable {}. Duration: {} ms. Total elapsed time: {} ms."), new Object[]{this.indexDescriptor.sstableDescriptor, elapsed - start, elapsed});
            start = elapsed;
            this.rowMapping.complete();
            for (PerColumnIndexWriter perIndexWriter : this.perIndexWriters) {
                perIndexWriter.complete(this.stopwatch);
            }
            elapsed = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            logger.debug(this.indexDescriptor.logMessage("Completed per-index writes for SSTable {}. Duration: {} ms. Total elapsed time: {} ms."), new Object[]{this.indexDescriptor.sstableDescriptor, elapsed - start, elapsed});
        }
        catch (Throwable t2) {
            logger.error(this.indexDescriptor.logMessage("Failed to complete an index build"), t2);
            this.abort(t2, true);
        }
    }

    @Override
    public void abort(Throwable accumulator) {
        this.abort(accumulator, false);
    }

    public void abort(Throwable accumulator, boolean fromIndex) {
        if (this.aborted) {
            return;
        }
        this.aborted = true;
        for (PerColumnIndexWriter perIndexWriter : this.perIndexWriters) {
            try {
                perIndexWriter.abort(accumulator);
            }
            catch (Throwable t2) {
                if (accumulator == null) continue;
                accumulator.addSuppressed(t2);
            }
        }
        if (!this.tokenOffsetWriterCompleted) {
            this.perSSTableWriter.abort();
        }
        if (fromIndex) {
            throw Throwables.unchecked(accumulator);
        }
    }

    private void addRow(Row row) throws IOException, InMemoryTrie.SpaceExhaustedException {
        PrimaryKey primaryKey = this.indexDescriptor.hasClustering() ? this.indexDescriptor.primaryKeyFactory.create(this.currentKey, (Clustering<?>)row.clustering()) : this.indexDescriptor.primaryKeyFactory.create(this.currentKey);
        this.perSSTableWriter.nextRow(primaryKey);
        this.rowMapping.add(primaryKey, this.sstableRowId);
        for (PerColumnIndexWriter w : this.perIndexWriters) {
            w.addRow(primaryKey, row, this.sstableRowId);
        }
        ++this.sstableRowId;
    }
}

