/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.StorageAttachedIndex;
import org.apache.cassandra.index.sai.disk.PerColumnIndexWriter;
import org.apache.cassandra.index.sai.disk.PerSSTableIndexWriter;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.RowMapping;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.format.OnDiskFormat;
import org.apache.cassandra.index.sai.disk.v1.ColumnCompletionMarkerUtil;
import org.apache.cassandra.index.sai.disk.v1.MemtableIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.SSTableComponentsWriter;
import org.apache.cassandra.index.sai.disk.v1.SSTableIndexWriter;
import org.apache.cassandra.index.sai.disk.v1.SkinnyPrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.V1SSTableIndex;
import org.apache.cassandra.index.sai.disk.v1.WidePrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentBuilder;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.cassandra.index.sai.utils.NamedMemoryLimiter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.apache.lucene.store.IndexInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1OnDiskFormat
implements OnDiskFormat {
    private static final Logger logger = LoggerFactory.getLogger(V1OnDiskFormat.class);
    @VisibleForTesting
    public static final Set<IndexComponent> SKINNY_PER_SSTABLE_COMPONENTS = EnumSet.of(IndexComponent.GROUP_COMPLETION_MARKER, new IndexComponent[]{IndexComponent.GROUP_META, IndexComponent.ROW_TO_TOKEN, IndexComponent.ROW_TO_PARTITION, IndexComponent.PARTITION_KEY_BLOCKS, IndexComponent.PARTITION_KEY_BLOCK_OFFSETS});
    @VisibleForTesting
    public static final Set<IndexComponent> WIDE_PER_SSTABLE_COMPONENTS = EnumSet.of(IndexComponent.GROUP_COMPLETION_MARKER, new IndexComponent[]{IndexComponent.GROUP_META, IndexComponent.ROW_TO_TOKEN, IndexComponent.ROW_TO_PARTITION, IndexComponent.PARTITION_TO_SIZE, IndexComponent.PARTITION_KEY_BLOCKS, IndexComponent.PARTITION_KEY_BLOCK_OFFSETS, IndexComponent.CLUSTERING_KEY_BLOCKS, IndexComponent.CLUSTERING_KEY_BLOCK_OFFSETS});
    @VisibleForTesting
    public static final Set<IndexComponent> LITERAL_COMPONENTS = EnumSet.of(IndexComponent.COLUMN_COMPLETION_MARKER, IndexComponent.META, IndexComponent.TERMS_DATA, IndexComponent.POSTING_LISTS);
    @VisibleForTesting
    public static final Set<IndexComponent> NUMERIC_COMPONENTS = EnumSet.of(IndexComponent.COLUMN_COMPLETION_MARKER, IndexComponent.META, IndexComponent.BALANCED_TREE, IndexComponent.POSTING_LISTS);
    @VisibleForTesting
    public static final Set<IndexComponent> VECTOR_COMPONENTS = EnumSet.of(IndexComponent.COLUMN_COMPLETION_MARKER, IndexComponent.META, IndexComponent.COMPRESSED_VECTORS, IndexComponent.TERMS_DATA, IndexComponent.POSTING_LISTS);
    public static final long SEGMENT_BUILD_MEMORY_LIMIT = DatabaseDescriptor.getSAISegmentWriteBufferSpace().toBytes();
    public static final NamedMemoryLimiter SEGMENT_BUILD_MEMORY_LIMITER = new NamedMemoryLimiter(SEGMENT_BUILD_MEMORY_LIMIT, "Storage Attached Index Segment Builder");
    public static final V1OnDiskFormat instance;

    protected V1OnDiskFormat() {
    }

    @Override
    public PrimaryKeyMap.Factory newPrimaryKeyMapFactory(IndexDescriptor indexDescriptor, SSTableReader sstable) {
        return indexDescriptor.hasClustering() ? new WidePrimaryKeyMap.Factory(indexDescriptor, sstable) : new SkinnyPrimaryKeyMap.Factory(indexDescriptor);
    }

    @Override
    public SSTableIndex newSSTableIndex(SSTableContext sstableContext, StorageAttachedIndex index) {
        return new V1SSTableIndex(sstableContext, index);
    }

    @Override
    public PerSSTableIndexWriter newPerSSTableIndexWriter(IndexDescriptor indexDescriptor) throws IOException {
        return new SSTableComponentsWriter(indexDescriptor);
    }

    @Override
    public PerColumnIndexWriter newPerColumnIndexWriter(StorageAttachedIndex index, IndexDescriptor indexDescriptor, LifecycleNewTracker tracker, RowMapping rowMapping) {
        if (tracker.opType() != OperationType.FLUSH || !index.isInitBuildStarted()) {
            NamedMemoryLimiter limiter = SEGMENT_BUILD_MEMORY_LIMITER;
            logger.info(index.identifier().logMessage("Starting a compaction index build. Global segment memory usage: {}"), (Object)FBUtilities.prettyPrintMemory(limiter.currentBytesUsed()));
            return new SSTableIndexWriter(indexDescriptor, index, limiter, index.isIndexValid());
        }
        return new MemtableIndexWriter(index.memtableIndexManager().getPendingMemtableIndex(tracker), indexDescriptor, index.termType(), index.identifier(), index.indexMetrics(), rowMapping);
    }

    @Override
    public boolean isPerSSTableIndexBuildComplete(IndexDescriptor indexDescriptor) {
        return indexDescriptor.hasComponent(IndexComponent.GROUP_COMPLETION_MARKER);
    }

    @Override
    public boolean isPerColumnIndexBuildComplete(IndexDescriptor indexDescriptor, IndexIdentifier indexIdentifier) {
        return indexDescriptor.hasComponent(IndexComponent.GROUP_COMPLETION_MARKER) && indexDescriptor.hasComponent(IndexComponent.COLUMN_COMPLETION_MARKER, indexIdentifier);
    }

    @Override
    public void validatePerSSTableIndexComponents(IndexDescriptor indexDescriptor, boolean checksum) {
        for (IndexComponent indexComponent : this.perSSTableIndexComponents(indexDescriptor.hasClustering())) {
            if (!this.isNotBuildCompletionMarker(indexComponent)) continue;
            V1OnDiskFormat.validateIndexComponent(indexDescriptor, null, indexComponent, checksum);
        }
    }

    @Override
    public void validatePerColumnIndexComponents(IndexDescriptor indexDescriptor, IndexTermType indexTermType, IndexIdentifier indexIdentifier, boolean checksum) {
        boolean isEmptyIndex = false;
        if (indexDescriptor.hasComponent(IndexComponent.COLUMN_COMPLETION_MARKER, indexIdentifier)) {
            V1OnDiskFormat.validateIndexComponent(indexDescriptor, indexIdentifier, IndexComponent.COLUMN_COMPLETION_MARKER, checksum);
            try {
                isEmptyIndex = ColumnCompletionMarkerUtil.isEmptyIndex(indexDescriptor, indexIdentifier);
            }
            catch (IOException e) {
                V1OnDiskFormat.rethrowIOException(e);
            }
        }
        for (IndexComponent indexComponent : this.perColumnIndexComponents(indexTermType)) {
            if (isEmptyIndex || !this.isNotBuildCompletionMarker(indexComponent)) continue;
            V1OnDiskFormat.validateIndexComponent(indexDescriptor, indexIdentifier, indexComponent, checksum);
        }
    }

    private static void validateIndexComponent(IndexDescriptor indexDescriptor, IndexIdentifier indexContext, IndexComponent indexComponent, boolean checksum) {
        try (IndexInput input = indexContext == null ? indexDescriptor.openPerSSTableInput(indexComponent) : indexDescriptor.openPerIndexInput(indexComponent, indexContext);){
            if (checksum) {
                SAICodecUtils.validateChecksum(input);
            } else {
                SAICodecUtils.validate(input);
            }
        }
        catch (Exception e) {
            logger.warn(indexDescriptor.logMessage("{} failed for index component {} on SSTable {}"), new Object[]{checksum ? "Checksum validation" : "Validation", indexComponent, indexDescriptor.sstableDescriptor});
            V1OnDiskFormat.rethrowIOException(e);
        }
    }

    private static void rethrowIOException(Exception e) {
        if (e instanceof IOException) {
            throw new UncheckedIOException((IOException)e);
        }
        if (e.getCause() instanceof IOException) {
            throw new UncheckedIOException((IOException)e.getCause());
        }
        throw Throwables.unchecked(e);
    }

    @Override
    public Set<IndexComponent> perSSTableIndexComponents(boolean hasClustering) {
        return hasClustering ? WIDE_PER_SSTABLE_COMPONENTS : SKINNY_PER_SSTABLE_COMPONENTS;
    }

    @Override
    public Set<IndexComponent> perColumnIndexComponents(IndexTermType indexTermType) {
        return indexTermType.isVector() ? VECTOR_COMPONENTS : (indexTermType.isLiteral() ? LITERAL_COMPONENTS : NUMERIC_COMPONENTS);
    }

    @Override
    public int openFilesPerSSTableIndex(boolean hasClustering) {
        return hasClustering ? 6 : 4;
    }

    @Override
    public int openFilesPerColumnIndex() {
        return 2;
    }

    protected boolean isNotBuildCompletionMarker(IndexComponent indexComponent) {
        return indexComponent != IndexComponent.GROUP_COMPLETION_MARKER && indexComponent != IndexComponent.COLUMN_COMPLETION_MARKER;
    }

    static {
        CassandraMetricsRegistry.MetricName bufferSpaceUsed = DefaultNameFactory.createMetricName("StorageAttachedIndex", "SegmentBufferSpaceUsedBytes", null);
        CassandraMetricsRegistry.Metrics.register(bufferSpaceUsed, SEGMENT_BUILD_MEMORY_LIMITER::currentBytesUsed);
        CassandraMetricsRegistry.MetricName bufferSpaceLimit = DefaultNameFactory.createMetricName("StorageAttachedIndex", "SegmentBufferSpaceLimitBytes", null);
        CassandraMetricsRegistry.Metrics.register(bufferSpaceLimit, () -> SEGMENT_BUILD_MEMORY_LIMIT);
        CassandraMetricsRegistry.MetricName buildsInProgress = DefaultNameFactory.createMetricName("StorageAttachedIndex", "ColumnIndexBuildsInProgress", null);
        CassandraMetricsRegistry.Metrics.register(buildsInProgress, SegmentBuilder::getActiveBuilderCount);
        instance = new V1OnDiskFormat();
    }
}

