/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.agrona.collections.IntArrayList;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.index.sai.disk.io.IndexOutputWriter;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeWalker;
import org.apache.cassandra.index.sai.disk.v1.postings.MergePostingList;
import org.apache.cassandra.index.sai.disk.v1.postings.PackedLongsPostingList;
import org.apache.cassandra.index.sai.disk.v1.postings.PostingsWriter;
import org.apache.cassandra.index.sai.postings.PeekablePostingList;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.PackedLongValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class BlockBalancedTreePostingsWriter
implements BlockBalancedTreeWalker.TraversalCallback {
    private static final Logger logger = LoggerFactory.getLogger(BlockBalancedTreePostingsWriter.class);
    private final TreeMap<Long, Integer> leafOffsetToNodeID = new TreeMap(Long::compareTo);
    private final Multimap<Integer, Integer> nodeToChildLeaves = HashMultimap.create();
    private final int minimumPostingsLeaves = CassandraRelevantProperties.SAI_MINIMUM_POSTINGS_LEAVES.getInt();
    private final int postingsSkip = CassandraRelevantProperties.SAI_POSTINGS_SKIP.getInt();
    int numNonLeafPostings = 0;
    int numLeafPostings = 0;

    @Override
    public void onLeaf(int leafNodeID, long leafBlockFP, IntArrayList pathToRoot) {
        Preconditions.checkArgument(!pathToRoot.containsInt(leafNodeID));
        Preconditions.checkArgument(pathToRoot.isEmpty() || leafNodeID > pathToRoot.get(pathToRoot.size() - 1));
        this.leafOffsetToNodeID.put(leafBlockFP, leafNodeID);
        for (int i = 0; i < pathToRoot.size(); ++i) {
            int level = i + 1;
            if (!this.isLevelEligibleForPostingList(level)) continue;
            int nodeID = pathToRoot.get(i);
            this.nodeToChildLeaves.put(nodeID, leafNodeID);
        }
    }

    public long finish(IndexOutputWriter out, List<PackedLongValues> leafPostings, IndexIdentifier indexIdentifier) throws IOException {
        Preconditions.checkState(leafPostings.size() == this.leafOffsetToNodeID.size(), "Expected equal number of postings lists (%s) and leaf offsets (%s).", leafPostings.size(), this.leafOffsetToNodeID.size());
        try (PostingsWriter postingsWriter = new PostingsWriter(out);){
            Iterator<PackedLongValues> postingsIterator = leafPostings.iterator();
            HashMap leafToPostings = new HashMap();
            this.leafOffsetToNodeID.forEach((fp, nodeID) -> leafToPostings.put(nodeID, (PackedLongValues)postingsIterator.next()));
            long postingsRamBytesUsed = leafPostings.stream().mapToLong(PackedLongValues::ramBytesUsed).sum();
            List internalNodeIDs = this.nodeToChildLeaves.keySet().stream().filter(i -> this.nodeToChildLeaves.get((Integer)i).size() >= this.minimumPostingsLeaves).collect(Collectors.toList());
            Collection<Integer> leafNodeIDs = this.leafOffsetToNodeID.values();
            logger.debug(indexIdentifier.logMessage("Writing posting lists for {} internal and {} leaf balanced tree nodes. Leaf postings memory usage: {}."), new Object[]{internalNodeIDs.size(), leafNodeIDs.size(), FBUtilities.prettyPrintMemory(postingsRamBytesUsed)});
            long startFP = out.getFilePointer();
            Stopwatch flushTime = Stopwatch.createStarted();
            TreeMap<Integer, Long> nodeIDToPostingsFilePointer = new TreeMap<Integer, Long>();
            PriorityQueue<PeekablePostingList> postingLists = new PriorityQueue<PeekablePostingList>(this.minimumPostingsLeaves, Comparator.comparingLong(PeekablePostingList::peek));
            for (int nodeID2 : Iterables.concat(internalNodeIDs, leafNodeIDs)) {
                Collection<Integer> leaves = this.nodeToChildLeaves.get(nodeID2);
                if (leaves.isEmpty()) {
                    leaves = Collections.singletonList(nodeID2);
                    ++this.numLeafPostings;
                } else {
                    ++this.numNonLeafPostings;
                }
                for (Integer leaf : leaves) {
                    postingLists.add(PeekablePostingList.makePeekable(new PackedLongsPostingList((PackedLongValues)leafToPostings.get(leaf))));
                }
                try (PostingList mergedPostingList = MergePostingList.merge(postingLists);){
                    long postingFilePosition = postingsWriter.write(mergedPostingList);
                    if (postingFilePosition >= 0L) {
                        nodeIDToPostingsFilePointer.put(nodeID2, postingFilePosition);
                    }
                }
                postingLists.clear();
            }
            flushTime.stop();
            logger.debug(indexIdentifier.logMessage("Flushed {} of posting lists for balanced tree nodes in {} ms."), (Object)FBUtilities.prettyPrintMemory(out.getFilePointer() - startFP), (Object)flushTime.elapsed(TimeUnit.MILLISECONDS));
            long indexFilePointer = out.getFilePointer();
            this.writeMap(nodeIDToPostingsFilePointer, out);
            postingsWriter.complete();
            long l = indexFilePointer;
            return l;
        }
    }

    private boolean isLevelEligibleForPostingList(int level) {
        return level > 1 && level % this.postingsSkip == 0;
    }

    private void writeMap(Map<Integer, Long> map, IndexOutput out) throws IOException {
        out.writeVInt(map.size());
        for (Map.Entry<Integer, Long> e : map.entrySet()) {
            out.writeVInt(e.getKey());
            out.writeVLong(e.getValue());
        }
    }
}

