/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import org.agrona.collections.IntArrayList;
import org.apache.cassandra.index.sai.disk.io.IndexInputReader;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.Throwables;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;

public class BlockBalancedTreeWalker
implements Closeable {
    final FileHandle treeIndexFile;
    final int bytesPerValue;
    final int numLeaves;
    final int treeDepth;
    final byte[] minPackedValue;
    final byte[] maxPackedValue;
    final long valueCount;
    final int maxValuesInLeafNode;
    final byte[] packedIndex;
    final long memoryUsage;

    BlockBalancedTreeWalker(FileHandle treeIndexFile, long treeIndexRoot) {
        this.treeIndexFile = treeIndexFile;
        try (RandomAccessReader reader = treeIndexFile.createReader();
             IndexInputReader indexInput = IndexInputReader.create(reader);){
            SAICodecUtils.validate(indexInput);
            ((IndexInput)indexInput).seek(treeIndexRoot);
            this.maxValuesInLeafNode = indexInput.readVInt();
            this.bytesPerValue = indexInput.readVInt();
            this.numLeaves = indexInput.readVInt();
            assert (this.numLeaves > 0);
            this.treeDepth = indexInput.readVInt();
            this.minPackedValue = new byte[this.bytesPerValue];
            this.maxPackedValue = new byte[this.bytesPerValue];
            ((DataInput)indexInput).readBytes(this.minPackedValue, 0, this.bytesPerValue);
            ((DataInput)indexInput).readBytes(this.maxPackedValue, 0, this.bytesPerValue);
            if (ByteArrayUtil.compareUnsigned(this.minPackedValue, 0, this.maxPackedValue, 0, this.bytesPerValue) > 0) {
                String message = String.format("Min packed value %s is > max packed value %s.", new BytesRef(this.minPackedValue), new BytesRef(this.maxPackedValue));
                throw new CorruptIndexException(message, indexInput);
            }
            this.valueCount = indexInput.readVLong();
            int numBytes = indexInput.readVInt();
            this.packedIndex = new byte[numBytes];
            ((DataInput)indexInput).readBytes(this.packedIndex, 0, numBytes);
            this.memoryUsage = ObjectSizes.sizeOfArray(this.packedIndex) + ObjectSizes.sizeOfArray(this.minPackedValue) + ObjectSizes.sizeOfArray(this.maxPackedValue);
        }
        catch (Throwable t2) {
            FileUtils.closeQuietly(treeIndexFile);
            throw Throwables.unchecked(t2);
        }
    }

    @VisibleForTesting
    public BlockBalancedTreeWalker(DataInput indexInput, long treeIndexRoot) throws IOException {
        this.treeIndexFile = null;
        indexInput.skipBytes(treeIndexRoot);
        this.maxValuesInLeafNode = indexInput.readVInt();
        this.bytesPerValue = indexInput.readVInt();
        this.numLeaves = indexInput.readVInt();
        assert (this.numLeaves > 0);
        this.treeDepth = indexInput.readVInt();
        this.minPackedValue = new byte[this.bytesPerValue];
        this.maxPackedValue = new byte[this.bytesPerValue];
        indexInput.readBytes(this.minPackedValue, 0, this.bytesPerValue);
        indexInput.readBytes(this.maxPackedValue, 0, this.bytesPerValue);
        if (ByteArrayUtil.compareUnsigned(this.minPackedValue, 0, this.maxPackedValue, 0, this.bytesPerValue) > 0) {
            String message = String.format("Min packed value %s is > max packed value %s.", new BytesRef(this.minPackedValue), new BytesRef(this.maxPackedValue));
            throw new CorruptIndexException(message, indexInput);
        }
        this.valueCount = indexInput.readVLong();
        int numBytes = indexInput.readVInt();
        this.packedIndex = new byte[numBytes];
        indexInput.readBytes(this.packedIndex, 0, numBytes);
        this.memoryUsage = ObjectSizes.sizeOfArray(this.packedIndex) + ObjectSizes.sizeOfArray(this.minPackedValue) + ObjectSizes.sizeOfArray(this.maxPackedValue);
    }

    public long memoryUsage() {
        return this.memoryUsage;
    }

    public TraversalState newTraversalState() {
        return new TraversalState();
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.treeIndexFile);
    }

    void traverse(TraversalCallback callback) {
        this.traverse(this.newTraversalState(), callback, new IntArrayList());
    }

    private void traverse(TraversalState state, TraversalCallback callback, IntArrayList pathToRoot) {
        if (state.atLeafNode()) {
            if (state.nodeExists()) {
                callback.onLeaf(state.nodeID, state.getLeafBlockFP(), pathToRoot);
            }
        } else {
            IntArrayList currentPath = new IntArrayList();
            currentPath.addAll(pathToRoot);
            currentPath.add(state.nodeID);
            state.pushLeft();
            this.traverse(state, callback, currentPath);
            state.pop();
            state.pushRight();
            this.traverse(state, callback, currentPath);
            state.pop();
        }
    }

    @NotThreadSafe
    final class TraversalState {
        final ByteArrayDataInput dataInput;
        final long[] leafBlockFPStack;
        final int[] leftNodePositions;
        final int[] rightNodePositions;
        final byte[][] splitValuesStack;
        int nodeID = 1;
        int level = 0;
        @VisibleForTesting
        int maxLevel;

        private TraversalState() {
            this.leafBlockFPStack = new long[BlockBalancedTreeWalker.this.treeDepth];
            this.leftNodePositions = new int[BlockBalancedTreeWalker.this.treeDepth];
            this.rightNodePositions = new int[BlockBalancedTreeWalker.this.treeDepth];
            this.splitValuesStack = new byte[BlockBalancedTreeWalker.this.treeDepth][];
            this.dataInput = new ByteArrayDataInput(BlockBalancedTreeWalker.this.packedIndex);
            this.readNodeData(false);
        }

        public void pushLeft() {
            int nodePosition = this.leftNodePositions[this.level];
            this.nodeID *= 2;
            ++this.level;
            this.maxLevel = Math.max(this.maxLevel, this.level);
            this.dataInput.setPosition(nodePosition);
            this.readNodeData(true);
        }

        public void pushRight() {
            int nodePosition = this.rightNodePositions[this.level];
            this.nodeID = this.nodeID * 2 + 1;
            ++this.level;
            this.maxLevel = Math.max(this.maxLevel, this.level);
            this.dataInput.setPosition(nodePosition);
            this.readNodeData(false);
        }

        public void pop() {
            this.nodeID /= 2;
            --this.level;
        }

        public boolean atLeafNode() {
            return this.nodeID >= BlockBalancedTreeWalker.this.numLeaves;
        }

        public boolean nodeExists() {
            return this.nodeID - BlockBalancedTreeWalker.this.numLeaves < BlockBalancedTreeWalker.this.numLeaves;
        }

        public long getLeafBlockFP() {
            return this.leafBlockFPStack[this.level];
        }

        public byte[] getSplitValue() {
            assert (!this.atLeafNode());
            return this.splitValuesStack[this.level];
        }

        private void readNodeData(boolean isLeft) {
            long l = this.leafBlockFPStack[this.level] = this.level == 0 ? 0L : this.leafBlockFPStack[this.level - 1];
            if (!isLeft) {
                int n = this.level;
                this.leafBlockFPStack[n] = this.leafBlockFPStack[n] + this.dataInput.readVLong();
            }
            if (!this.atLeafNode()) {
                int code = this.dataInput.readVInt();
                int prefix = code % (1 + BlockBalancedTreeWalker.this.bytesPerValue);
                int suffix = BlockBalancedTreeWalker.this.bytesPerValue - prefix;
                this.pushSplitValueStack();
                if (suffix > 0) {
                    int firstDiffByteDelta = code / (1 + BlockBalancedTreeWalker.this.bytesPerValue);
                    if (isLeft) {
                        firstDiffByteDelta = -firstDiffByteDelta;
                    }
                    int oldByte = this.splitValuesStack[this.level][prefix] & 0xFF;
                    this.splitValuesStack[this.level][prefix] = (byte)(oldByte + firstDiffByteDelta);
                    this.dataInput.readBytes(this.splitValuesStack[this.level], prefix + 1, suffix - 1);
                }
                int leftNumBytes = this.nodeID * 2 < BlockBalancedTreeWalker.this.numLeaves ? this.dataInput.readVInt() : 0;
                this.leftNodePositions[this.level] = this.dataInput.getPosition();
                this.rightNodePositions[this.level] = this.leftNodePositions[this.level] + leftNumBytes;
            }
        }

        private void pushSplitValueStack() {
            if (this.splitValuesStack[this.level] == null) {
                this.splitValuesStack[this.level] = new byte[BlockBalancedTreeWalker.this.bytesPerValue];
            }
            if (this.level == 0) {
                Arrays.fill(this.splitValuesStack[this.level], (byte)0);
            } else {
                System.arraycopy(this.splitValuesStack[this.level - 1], 0, this.splitValuesStack[this.level], 0, BlockBalancedTreeWalker.this.bytesPerValue);
            }
        }
    }

    static interface TraversalCallback {
        public void onLeaf(int var1, long var2, IntArrayList var4);
    }
}

