/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.index.sai.metrics.AbstractMetrics;
import org.apache.cassandra.index.sai.metrics.QueryEventListener;
import org.apache.cassandra.index.sai.utils.IndexIdentifier;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;

public abstract class ColumnQueryMetrics
extends AbstractMetrics {
    protected ColumnQueryMetrics(IndexIdentifier indexIdentifier) {
        super(indexIdentifier, "ColumnQueryMetrics");
    }

    private static class PostingListEventsMetrics
    implements QueryEventListener.PostingListEventListener {
        private final Meter postingDecodes;

        private PostingListEventsMetrics(Meter postingDecodes) {
            this.postingDecodes = postingDecodes;
        }

        @Override
        public void onAdvance() {
        }

        @Override
        public void postingDecoded(long postingsDecoded) {
            this.postingDecodes.mark(postingsDecoded);
        }
    }

    public static class BalancedTreeIndexMetrics
    extends ColumnQueryMetrics
    implements QueryEventListener.BalancedTreeEventListener {
        private static final String BALANCED_TREE_POSTINGS_TYPE = "BalancedTreePostings";
        private final Timer intersectionLatency = CassandraMetricsRegistry.Metrics.timer(this.createMetricName("BalancedTreeIntersectionLatency"));
        private final Meter postingsNumPostings;
        private final Meter intersectionEarlyExits = CassandraMetricsRegistry.Metrics.meter(this.createMetricName("BalancedTreeIntersectionEarlyExits"));
        private final QueryEventListener.PostingListEventListener postingsListener;

        public BalancedTreeIndexMetrics(IndexIdentifier indexIdentifier) {
            super(indexIdentifier);
            this.postingsNumPostings = CassandraMetricsRegistry.Metrics.meter(this.createMetricName("NumPostings", BALANCED_TREE_POSTINGS_TYPE));
            Meter postingDecodes = CassandraMetricsRegistry.Metrics.meter(this.createMetricName("PostingDecodes", BALANCED_TREE_POSTINGS_TYPE));
            this.postingsListener = new PostingListEventsMetrics(postingDecodes);
        }

        @Override
        public void onIntersectionComplete(long intersectionTotalTime, TimeUnit unit) {
            this.intersectionLatency.update(intersectionTotalTime, unit);
        }

        @Override
        public void onIntersectionEarlyExit() {
            this.intersectionEarlyExits.mark();
        }

        @Override
        public void postingListsHit(int count) {
            this.postingsNumPostings.mark(count);
        }

        @Override
        public void onSegmentHit() {
        }

        @Override
        public QueryEventListener.PostingListEventListener postingListEventListener() {
            return this.postingsListener;
        }
    }

    public static class TrieIndexMetrics
    extends ColumnQueryMetrics
    implements QueryEventListener.TrieIndexEventListener {
        private static final String TRIE_POSTINGS_TYPE = "Postings";
        private final Timer termsTraversalTotalTime = CassandraMetricsRegistry.Metrics.timer(this.createMetricName("TermsLookupLatency"));
        private final QueryEventListener.PostingListEventListener postingsListener;

        public TrieIndexMetrics(IndexIdentifier indexIdentifier) {
            super(indexIdentifier);
            Meter postingDecodes = CassandraMetricsRegistry.Metrics.meter(this.createMetricName("PostingDecodes", TRIE_POSTINGS_TYPE));
            this.postingsListener = new PostingListEventsMetrics(postingDecodes);
        }

        @Override
        public void onSegmentHit() {
        }

        @Override
        public void onTraversalComplete(long traversalTotalTime, TimeUnit unit) {
            this.termsTraversalTotalTime.update(traversalTotalTime, unit);
        }

        @Override
        public QueryEventListener.PostingListEventListener postingListEventListener() {
            return this.postingsListener;
        }
    }
}

