/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;

public class Component {
    public static final char separator = '-';
    public final Type type;
    public final String name;
    public final int hashCode;

    private Component(Type type) {
        this(type, type.repr);
    }

    private Component(Type type, String name) {
        assert (name != null) : "Component name cannot be null";
        this.type = type;
        this.name = name;
        this.hashCode = Objects.hash(type, name);
    }

    public String name() {
        return this.name;
    }

    public static Component parse(String name, SSTableFormat<?, ?> format) {
        return Type.createComponent(name, format);
    }

    public static Iterable<Component> getSingletonsFor(SSTableFormat<?, ?> format) {
        return Iterables.transform(Iterables.filter(Type.all, t2 -> t2.singleton != null && t2.formatClass.isAssignableFrom(format.getClass())), t2 -> t2.singleton);
    }

    public static Iterable<Component> getSingletonsFor(Class<? extends SSTableFormat<?, ?>> formatClass) {
        return Iterables.transform(Iterables.filter(Type.all, t2 -> t2.singleton != null && t2.formatClass.isAssignableFrom(formatClass)), t2 -> t2.singleton);
    }

    public boolean isValidFor(Descriptor descriptor) {
        return this.type.formatClass.isAssignableFrom(descriptor.version.format.getClass());
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component that = (Component)o;
        return this.hashCode == that.hashCode && this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static final class Type {
        private static final CopyOnWriteArrayList<Type> typesCollector = new CopyOnWriteArrayList();
        public static final List<Type> all = Collections.unmodifiableList(typesCollector);
        public final int id;
        public final String name;
        public final String repr;
        public final boolean streamable;
        private final Component singleton;
        public final Class<? extends SSTableFormat> formatClass;

        public static Type create(String name, String repr, boolean streamable, Class<? extends SSTableFormat<?, ?>> formatClass) {
            return new Type(name, repr, false, streamable, formatClass);
        }

        public static Type createSingleton(String name, String repr, boolean streamable, Class<? extends SSTableFormat<?, ?>> formatClass) {
            return new Type(name, repr, true, streamable, formatClass);
        }

        private Type(String name, String repr, boolean isSingleton, boolean streamable, Class<? extends SSTableFormat<?, ?>> formatClass) {
            this.name = Objects.requireNonNull(name);
            this.repr = repr;
            this.streamable = streamable;
            this.id = typesCollector.size();
            this.formatClass = formatClass == null ? SSTableFormat.class : formatClass;
            this.singleton = isSingleton ? new Component(this) : null;
            Type.registerType(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void registerType(Type type) {
            CopyOnWriteArrayList<Type> copyOnWriteArrayList = typesCollector;
            synchronized (copyOnWriteArrayList) {
                if (typesCollector.stream().anyMatch(t2 -> (Objects.equals(t2.name, type.name) || Objects.equals(t2.repr, type.repr)) && t2.formatClass.isAssignableFrom(type.formatClass))) {
                    throw new AssertionError((Object)("Type named " + type.name + " is already registered"));
                }
                typesCollector.add(type);
            }
        }

        @VisibleForTesting
        public static Type fromRepresentation(String repr, SSTableFormat<?, ?> format) {
            for (Type type : all) {
                if (type.repr == null || !Pattern.matches(type.repr, repr) || !type.formatClass.isAssignableFrom(format.getClass())) continue;
                return type;
            }
            return SSTableFormat.Components.Types.CUSTOM;
        }

        public static Component createComponent(String repr, SSTableFormat<?, ?> format) {
            Type type = Type.fromRepresentation(repr, format);
            if (type.singleton != null) {
                return type.singleton;
            }
            return new Component(type, repr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Type type = (Type)o;
            return this.id == type.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }

        public Component getSingleton() {
            return Objects.requireNonNull(this.singleton);
        }

        public Component createComponent(String repr) {
            Preconditions.checkArgument(this.singleton == null);
            return new Component(this, repr);
        }
    }
}

