/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.codahale.metrics.Gauge;
import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.function.Function;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.sstable.GaugeProvider;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class SimpleGaugeProvider<T extends Number, R extends SSTableReader>
extends GaugeProvider<T> {
    private final Function<SSTableReader, R> mapper;
    private final Function<Iterable<R>, T> combiner;

    public SimpleGaugeProvider(Function<SSTableReader, R> mapper, String name, Function<Iterable<R>, T> combiner) {
        super(name);
        this.mapper = mapper;
        this.combiner = combiner;
    }

    @Override
    public Gauge<T> getTableGauge(ColumnFamilyStore cfs) {
        return () -> this.combine(cfs.getLiveSSTables());
    }

    @Override
    public Gauge<T> getKeyspaceGauge(Keyspace keyspace) {
        return () -> this.combine(SimpleGaugeProvider.getAllReaders(keyspace));
    }

    @Override
    public Gauge<T> getGlobalGauge() {
        return () -> this.combine(Iterables.concat(Iterables.transform(Keyspace.all(), SimpleGaugeProvider::getAllReaders)));
    }

    private T combine(Iterable<SSTableReader> allReaders) {
        Iterable readers = Iterables.filter(Iterables.transform(allReaders, this.mapper::apply), Objects::nonNull);
        return (T)((Number)this.combiner.apply(readers));
    }

    private static Iterable<SSTableReader> getAllReaders(Keyspace keyspace) {
        return Iterables.concat(Iterables.transform(keyspace.getColumnFamilyStores(), ColumnFamilyStore::getLiveSSTables));
    }
}

