/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.tries;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.apache.cassandra.io.tries.IncrementalTrieWriter;
import org.apache.cassandra.io.tries.SerializationNode;
import org.apache.cassandra.io.tries.TrieSerializer;
import org.apache.cassandra.io.tries.Walker;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.concurrent.LightweightRecycler;
import org.apache.cassandra.utils.concurrent.ThreadLocals;

public abstract class IncrementalTrieWriterBase<VALUE, DEST, NODE extends BaseNode<VALUE, NODE>>
implements IncrementalTrieWriter<VALUE> {
    protected final Deque<NODE> stack = new ArrayDeque<NODE>();
    protected final TrieSerializer<VALUE, ? super DEST> serializer;
    protected final DEST dest;
    protected ByteComparable prev = null;
    long count = 0L;

    protected IncrementalTrieWriterBase(TrieSerializer<VALUE, ? super DEST> serializer, DEST dest, NODE root) {
        this.serializer = serializer;
        this.dest = dest;
        this.stack.addLast(root);
    }

    protected void reset(NODE root) {
        this.prev = null;
        this.count = 0L;
        this.stack.clear();
        this.stack.addLast(root);
    }

    @Override
    public void close() {
        this.prev = null;
        this.count = 0L;
        this.stack.clear();
    }

    @Override
    public void add(ByteComparable next, VALUE value) throws IOException {
        ++this.count;
        int stackpos = 0;
        ByteSource sn = next.asComparableBytes(Walker.BYTE_COMPARABLE_VERSION);
        int n = sn.next();
        if (this.prev != null) {
            ByteSource sp = this.prev.asComparableBytes(Walker.BYTE_COMPARABLE_VERSION);
            int p = sp.next();
            while (n == p) {
                assert (n != -1) : String.format("Incremental trie requires unique sorted keys, got equal %s(%s) after %s(%s).", next, next.byteComparableAsString(Walker.BYTE_COMPARABLE_VERSION), this.prev, this.prev.byteComparableAsString(Walker.BYTE_COMPARABLE_VERSION));
                ++stackpos;
                n = sn.next();
                p = sp.next();
            }
            assert (p < n) : String.format("Incremental trie requires sorted keys, got %s(%s) after %s(%s).", next, next.byteComparableAsString(Walker.BYTE_COMPARABLE_VERSION), this.prev, this.prev.byteComparableAsString(Walker.BYTE_COMPARABLE_VERSION));
        }
        this.prev = next;
        while (this.stack.size() > stackpos + 1) {
            this.completeLast();
        }
        BaseNode node = (BaseNode)this.stack.getLast();
        while (n != -1) {
            node = node.addChild((byte)n);
            this.stack.addLast(node);
            ++stackpos;
            n = sn.next();
        }
        VALUE existingPayload = node.setPayload(value);
        assert (existingPayload == null);
    }

    @Override
    public long complete() throws IOException {
        BaseNode root = (BaseNode)this.stack.getFirst();
        if (root.filePos != -1L) {
            return root.filePos;
        }
        return ((BaseNode)this.performCompletion()).filePos;
    }

    NODE performCompletion() throws IOException {
        NODE root = null;
        while (!this.stack.isEmpty()) {
            root = this.completeLast();
        }
        this.stack.addLast(root);
        return root;
    }

    @Override
    public long count() {
        return this.count;
    }

    protected NODE completeLast() throws IOException {
        BaseNode node = (BaseNode)this.stack.removeLast();
        this.complete(node);
        return (NODE)node;
    }

    abstract void complete(NODE var1) throws IOException;

    @Override
    public abstract IncrementalTrieWriter.PartialTail makePartialRoot() throws IOException;

    static abstract class BaseNode<VALUE, NODE extends BaseNode<VALUE, NODE>>
    implements SerializationNode<VALUE> {
        private static final int CHILDREN_LIST_RECYCLER_LIMIT = 1024;
        private static final LightweightRecycler<ArrayList> CHILDREN_LIST_RECYCLER = ThreadLocals.createLightweightRecycler(1024);
        private static final ArrayList EMPTY_LIST = new ArrayList(0);
        VALUE payload;
        ArrayList<NODE> children = EMPTY_LIST;
        final int transition;
        long filePos = -1L;

        private static <NODE> ArrayList<NODE> allocateChildrenList() {
            return CHILDREN_LIST_RECYCLER.reuseOrAllocate(() -> new ArrayList(4));
        }

        private static <NODE> void recycleChildrenList(ArrayList<NODE> children) {
            CHILDREN_LIST_RECYCLER.tryRecycle(children);
        }

        BaseNode(int transition) {
            this.transition = transition;
        }

        @Override
        public VALUE payload() {
            return this.payload;
        }

        public VALUE setPayload(VALUE newPayload) {
            VALUE p = this.payload;
            this.payload = newPayload;
            return p;
        }

        public NODE addChild(byte b) {
            assert (this.children.isEmpty() || (((BaseNode)this.children.get((int)(this.children.size() - 1))).transition & 0xFF) < (b & 0xFF));
            NODE node = this.newNode(b);
            if (this.children == EMPTY_LIST) {
                this.children = BaseNode.allocateChildrenList();
            }
            this.children.add(node);
            return node;
        }

        @Override
        public int childCount() {
            return this.children.size();
        }

        void finalizeWithPosition(long position) {
            this.filePos = position;
            if (this.children != EMPTY_LIST) {
                BaseNode.recycleChildrenList(this.children);
            }
            this.children = null;
            this.payload = null;
        }

        @Override
        public int transition(int i) {
            return ((BaseNode)this.children.get((int)i)).transition;
        }

        public String toString() {
            return String.format("%02x", this.transition);
        }

        abstract NODE newNode(byte var1);
    }

    static class PTail
    implements IncrementalTrieWriter.PartialTail {
        long root;
        long cutoff;
        long count;
        ByteBuffer tail;

        PTail() {
        }

        @Override
        public long root() {
            return this.root;
        }

        @Override
        public long cutoff() {
            return this.cutoff;
        }

        @Override
        public ByteBuffer tail() {
            return this.tail;
        }

        @Override
        public long count() {
            return this.count;
        }
    }
}

