/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SimpleDateSerializer
extends TypeSerializer<Integer> {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC).withResolverStyle(ResolverStyle.STRICT);
    private static final long minSupportedDateMillis = TimeUnit.DAYS.toMillis(Integer.MIN_VALUE);
    private static final long maxSupportedDateMillis = TimeUnit.DAYS.toMillis(Integer.MAX_VALUE);
    private static final long maxSupportedDays = (long)Math.pow(2.0, 32.0) - 1L;
    private static final long byteOrderShift = (long)Math.pow(2.0, 31.0) * 2L;
    private static final Pattern rawPattern = Pattern.compile("^-?\\d+$");
    public static final SimpleDateSerializer instance = new SimpleDateSerializer();

    @Override
    public <V> Integer deserialize(V value, ValueAccessor<V> accessor) {
        return accessor.isEmpty(value) ? null : Integer.valueOf(accessor.toInt(value));
    }

    @Override
    public ByteBuffer serialize(Integer value) {
        return value == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : ByteBufferUtil.bytes(value);
    }

    public static int dateStringToDays(String source) throws MarshalException {
        if (rawPattern.matcher(source).matches()) {
            return SimpleDateSerializer.parseRaw(source);
        }
        try {
            LocalDate parsed = formatter.parse((CharSequence)source, LocalDate::from);
            long millis = parsed.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
            if (millis < minSupportedDateMillis) {
                throw new MarshalException(String.format("Input date %s is less than min supported date %s", source, ZonedDateTime.ofInstant(Instant.ofEpochMilli(minSupportedDateMillis), ZoneOffset.UTC).toString()));
            }
            if (millis > maxSupportedDateMillis) {
                throw new MarshalException(String.format("Input date %s is greater than max supported date %s", source, ZonedDateTime.ofInstant(Instant.ofEpochMilli(maxSupportedDateMillis), ZoneOffset.UTC).toString()));
            }
            return SimpleDateSerializer.timeInMillisToDay(millis);
        }
        catch (ArithmeticException | DateTimeParseException e1) {
            throw new MarshalException(String.format("Unable to coerce '%s' to a formatted date (long)", source), e1);
        }
    }

    private static int parseRaw(String source) {
        try {
            long result = Long.parseLong(source);
            if (result < 0L || result > maxSupportedDays) {
                throw new NumberFormatException("Input out of bounds: " + source);
            }
            if (result >= Integer.MAX_VALUE) {
                result -= byteOrderShift;
            }
            return (int)result;
        }
        catch (NumberFormatException | DateTimeParseException e) {
            throw new MarshalException(String.format("Unable to make unsigned int (for date) from: '%s'", source), e);
        }
    }

    public static int timeInMillisToDay(long millis) {
        return (int)(Duration.ofMillis(millis).toDays() - Integer.MIN_VALUE);
    }

    public static long dayToTimeInMillis(int days) {
        return Duration.ofDays(days + Integer.MIN_VALUE).toMillis();
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        if (accessor.size(value) != 4) {
            throw new MarshalException(String.format("Expected 4 byte long for date (%d)", accessor.size(value)));
        }
    }

    @Override
    public String toString(Integer value) {
        if (value == null) {
            return "";
        }
        return Instant.ofEpochMilli(SimpleDateSerializer.dayToTimeInMillis(value)).atZone(ZoneOffset.UTC).format(formatter);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public boolean shouldQuoteCQLLiterals() {
        return true;
    }
}

