/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Preconditions;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.SyncFailedException;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.cassandra.config.CassandraRelevantEnv;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncUtil {
    public static final boolean SKIP_SYNC;
    private static final Logger logger;

    public static MappedByteBuffer force(MappedByteBuffer buf) {
        Preconditions.checkNotNull(buf);
        Object attachment = MemoryUtil.getAttachment(buf);
        if (attachment instanceof Runnable) {
            ((Runnable)attachment).run();
            return buf;
        }
        if (SKIP_SYNC) {
            return buf;
        }
        return buf.force();
    }

    public static void sync(FileDescriptor fd) throws SyncFailedException {
        Preconditions.checkNotNull(fd);
        if (!SKIP_SYNC) {
            fd.sync();
        }
    }

    public static void force(FileChannel fc, boolean metaData) throws IOException {
        Preconditions.checkNotNull(fc);
        if (SKIP_SYNC) {
            if (!fc.isOpen()) {
                throw new ClosedChannelException();
            }
        } else {
            fc.force(metaData);
        }
    }

    public static void sync(FileOutputStream fos) throws IOException {
        Preconditions.checkNotNull(fos);
        SyncUtil.sync(fos.getFD());
    }

    public static void trySync(int fd) {
        if (SKIP_SYNC) {
            return;
        }
        NativeLibrary.trySync(fd);
    }

    public static void trySyncDir(File dir) {
        if (SKIP_SYNC) {
            return;
        }
        int directoryFD = NativeLibrary.tryOpenDirectory(dir.path());
        try {
            SyncUtil.trySync(directoryFD);
        }
        finally {
            NativeLibrary.tryCloseFD(directoryFD);
        }
    }

    static {
        logger = LoggerFactory.getLogger(SyncUtil.class);
        boolean skipSyncProperty = CassandraRelevantProperties.TEST_CASSANDRA_SKIP_SYNC.getBoolean();
        boolean skipSyncEnv = CassandraRelevantEnv.CASSANDRA_SKIP_SYNC.getBoolean();
        boolean bl = SKIP_SYNC = skipSyncProperty || skipSyncEnv;
        if (SKIP_SYNC) {
            logger.info("Skip fsync enabled due to property {} and environment {}", (Object)skipSyncProperty, (Object)skipSyncEnv);
        }
    }
}

