/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.apache.cassandra.utils.Closeable;
import org.apache.cassandra.utils.Shared;

@Shared(scope={Shared.Scope.SIMULATION})
public interface WithResources {
    public Closeable get();

    default public boolean isNoOp() {
        return false;
    }

    default public WithResources and(WithResources withResources) {
        return WithResources.and(this, withResources);
    }

    public static WithResources none() {
        return None.INSTANCE;
    }

    public static WithResources and(WithResources first, WithResources second) {
        if (second.isNoOp()) {
            return first;
        }
        if (first.isNoOp()) {
            return second;
        }
        return () -> {
            Closeable a = first.get();
            try {
                Closeable b = second.get();
                return () -> {
                    try {
                        a.close();
                    }
                    finally {
                        b.close();
                    }
                };
            }
            catch (Throwable t2) {
                try {
                    a.close();
                }
                catch (Throwable t22) {
                    t2.addSuppressed(t22);
                }
                throw t2;
            }
        };
    }

    public static class None
    implements WithResources {
        static final None INSTANCE = new None();

        private None() {
        }

        @Override
        public Closeable get() {
            return () -> {};
        }

        @Override
        public boolean isNoOp() {
            return true;
        }
    }
}

