/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.MemtableCleaner;
import org.apache.cassandra.utils.memory.MemtableCleanerThread;

public abstract class MemtablePool {
    final MemtableCleanerThread<?> cleaner;
    public final SubPool onHeap;
    public final SubPool offHeap;
    public final Timer blockedOnAllocating;
    public final Gauge<Long> numPendingTasks;
    final WaitQueue hasRoom = WaitQueue.newWaitQueue();
    private static final AtomicLongFieldUpdater<SubPool> reclaimingUpdater = AtomicLongFieldUpdater.newUpdater(SubPool.class, "reclaiming");
    private static final AtomicLongFieldUpdater<SubPool> allocatedUpdater = AtomicLongFieldUpdater.newUpdater(SubPool.class, "allocated");
    private static final AtomicLongFieldUpdater<SubPool> nextCleanUpdater = AtomicLongFieldUpdater.newUpdater(SubPool.class, "nextClean");

    MemtablePool(long maxOnHeapMemory, long maxOffHeapMemory, float cleanThreshold, MemtableCleaner cleaner) {
        Preconditions.checkArgument(cleaner != null, "Cleaner should not be null");
        this.onHeap = this.getSubPool(maxOnHeapMemory, cleanThreshold);
        this.offHeap = this.getSubPool(maxOffHeapMemory, cleanThreshold);
        this.cleaner = this.getCleaner(cleaner);
        DefaultNameFactory nameFactory = new DefaultNameFactory("MemtablePool");
        this.blockedOnAllocating = CassandraMetricsRegistry.Metrics.timer(nameFactory.createMetricName("BlockedOnAllocation"));
        this.numPendingTasks = CassandraMetricsRegistry.Metrics.register(nameFactory.createMetricName("PendingFlushTasks"), () -> this.cleaner.numPendingTasks());
    }

    SubPool getSubPool(long limit, float cleanThreshold) {
        return new SubPool(limit, cleanThreshold);
    }

    MemtableCleanerThread<?> getCleaner(MemtableCleaner cleaner) {
        return cleaner == null ? null : new MemtableCleanerThread<MemtablePool>(this, cleaner);
    }

    @VisibleForTesting
    public void shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, this.cleaner);
    }

    public abstract MemtableAllocator newAllocator(String var1);

    public boolean needsCleaning() {
        return this.onHeap.needsCleaning() || this.offHeap.needsCleaning();
    }

    public Long getNumPendingtasks() {
        return this.numPendingTasks.getValue();
    }

    public class SubPool {
        public final long limit;
        public final float cleanThreshold;
        volatile long allocated;
        volatile long reclaiming;
        volatile long nextClean;

        public SubPool(long limit, float cleanThreshold) {
            this.limit = limit;
            this.cleanThreshold = cleanThreshold;
        }

        boolean needsCleaning() {
            return this.used() > this.nextClean && this.updateNextClean();
        }

        void maybeClean() {
            if (this.needsCleaning() && MemtablePool.this.cleaner != null) {
                MemtablePool.this.cleaner.trigger();
            }
        }

        private boolean updateNextClean() {
            long reclaiming;
            long next;
            long current;
            while ((current = this.nextClean) != (next = (reclaiming = this.reclaiming) + (long)((float)this.limit * this.cleanThreshold)) && !nextCleanUpdater.compareAndSet(this, current, next)) {
            }
            return this.used() > next;
        }

        boolean tryAllocate(long size) {
            long cur;
            do {
                if ((cur = this.allocated) + size <= this.limit) continue;
                return false;
            } while (!allocatedUpdater.compareAndSet(this, cur, cur + size));
            return true;
        }

        private void adjustAllocated(long size) {
            long cur;
            while (!allocatedUpdater.compareAndSet(this, cur = this.allocated, cur + size)) {
            }
        }

        void allocated(long size) {
            assert (size >= 0L);
            if (size == 0L) {
                return;
            }
            this.adjustAllocated(size);
            this.maybeClean();
        }

        void acquired() {
            this.maybeClean();
        }

        void released(long size) {
            assert (size >= 0L) : "Negative released: " + size;
            this.adjustAllocated(-size);
            MemtablePool.this.hasRoom.signalAll();
        }

        void reclaiming(long size) {
            if (size == 0L) {
                return;
            }
            reclaimingUpdater.addAndGet(this, size);
        }

        void reclaimed(long size) {
            if (size == 0L) {
                return;
            }
            reclaimingUpdater.addAndGet(this, -size);
            if (this.updateNextClean() && MemtablePool.this.cleaner != null) {
                MemtablePool.this.cleaner.trigger();
            }
        }

        public long used() {
            return this.allocated;
        }

        public long getReclaiming() {
            return this.reclaiming;
        }

        public float reclaimingRatio() {
            float r = (float)this.reclaiming / (float)this.limit;
            if (Float.isNaN(r)) {
                return 0.0f;
            }
            return r;
        }

        public float usedRatio() {
            float r = (float)this.allocated / (float)this.limit;
            if (Float.isNaN(r)) {
                return 0.0f;
            }
            return r;
        }

        public MemtableAllocator.SubAllocator newAllocator() {
            return new MemtableAllocator.SubAllocator(this);
        }

        public WaitQueue hasRoom() {
            return MemtablePool.this.hasRoom;
        }

        public Timer.Context blockedTimerContext() {
            return MemtablePool.this.blockedOnAllocating.time();
        }
    }
}

