/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.strategies;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.github.jamm.CannotMeasureObjectException;
import org.github.jamm.VM;
import org.github.jamm.strategies.ContendedUtils;
import org.github.jamm.strategies.MemoryLayoutBasedStrategy;
import org.github.jamm.utils.MathUtils;
import sun.misc.Unsafe;

public final class UnsafeStrategy
extends MemoryLayoutBasedStrategy {
    private static final Unsafe UNSAFE = VM.getUnsafe();
    private static final int ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(Object[].class);
    private final MethodHandle isRecordMH;
    private final MethodHandle isHiddenMH;
    private final MemoryLayoutBasedStrategy hiddenClassesOrRecordsStrategy;

    public UnsafeStrategy(MethodHandle isRecordMH, MethodHandle isHiddenMH, MemoryLayoutBasedStrategy strategy) {
        this.isRecordMH = isRecordMH;
        this.isHiddenMH = isHiddenMH;
        this.hiddenClassesOrRecordsStrategy = strategy;
    }

    @Override
    public long measureInstance(Object instance, Class<?> type) {
        try {
            if (this.isRecordMH.invoke(type).booleanValue() || this.isHiddenMH.invoke(type).booleanValue()) {
                return this.hiddenClassesOrRecordsStrategy.measureInstance(instance, type);
            }
            long size = 0L;
            boolean isLastFieldWithinContentionGroup = false;
            while (type != null) {
                for (Field f : type.getDeclaredFields()) {
                    long previousSize;
                    if (Modifier.isStatic(f.getModifiers()) || (previousSize = size) >= (size = Math.max(size, UNSAFE.objectFieldOffset(f) + (long)this.measureField(f.getType())))) continue;
                    isLastFieldWithinContentionGroup = ContendedUtils.isFieldAnnotatedWithContended(f);
                }
                if (ContendedUtils.isClassAnnotatedWithContended(type) && ContendedUtils.isContendedEnabled(type)) {
                    size += (long)MEMORY_LAYOUT.getContendedPaddingWidth();
                }
                type = type.getSuperclass();
            }
            if (size == 0L) {
                size = MEMORY_LAYOUT.getObjectHeaderSize();
            } else if (isLastFieldWithinContentionGroup) {
                size += (long)MEMORY_LAYOUT.getContendedPaddingWidth();
            }
            size = size > 0L ? size : (long)MEMORY_LAYOUT.getObjectHeaderSize();
            return MathUtils.roundTo(size, MEMORY_LAYOUT.getObjectAlignment());
        }
        catch (Throwable e) {
            throw new CannotMeasureObjectException("The object of type " + type + " cannot be measured by the unsafe strategy", e);
        }
    }

    @Override
    protected int arrayBaseOffset() {
        return ARRAY_BASE_OFFSET;
    }
}

