/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gridkit.jvmtool.GlobHelper;
import org.gridkit.util.formating.TextTree;

public class StackTreeAnalyzer {
    private static final StackTraceElement STUB = new StackTraceElement("", "", null, -1);
    private Node root = new Node();
    private int maxDepth = Integer.MAX_VALUE;
    private boolean trimLineNumbers = false;
    private boolean compressedTree = false;
    private double branchVisibilityRelativeThreshold = 0.0;
    private double branchVisibilityAbsoluteThreshold = 0.0;
    private boolean showSkeletonTails = false;
    private StringBuilder maskBuilder;
    private Pattern maskPattern;
    private StringBuilder classLumpBuilder;
    private Pattern classLumpPattern;
    private StringBuilder skeletonBuilder;
    private Pattern skeletonPattern;
    private StringBuilder tipBuilder;
    private Pattern tipPattern;

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setTrimLineNumbers(boolean trim) {
        this.trimLineNumbers = trim;
    }

    public void setCompressedTree(boolean compress) {
        this.compressedTree = compress;
    }

    public void setRelativeVisibilityThreshold(double threshold) {
        this.branchVisibilityRelativeThreshold = threshold;
    }

    public void setAbsoluteVisibilityThreshold(double threshold) {
        this.branchVisibilityAbsoluteThreshold = threshold;
    }

    public void setShowSkeletonTails(boolean show) {
        this.showSkeletonTails = show;
    }

    public void mask(String pattern) {
        Pattern p = GlobHelper.translate(pattern, ".");
        this.maskPattern = null;
        if (this.maskBuilder == null) {
            this.maskBuilder = new StringBuilder();
        } else {
            this.maskBuilder.append("|");
        }
        this.maskBuilder.append("(").append(p.pattern()).append(")");
    }

    public void lumpClass(String pattern) {
        Pattern p = GlobHelper.translate(pattern, ".");
        this.classLumpPattern = null;
        if (this.classLumpBuilder == null) {
            this.classLumpBuilder = new StringBuilder();
        } else {
            this.classLumpBuilder.append("|");
        }
        this.classLumpBuilder.append("(").append(p.pattern()).append(")");
    }

    public void retain(String pattern) {
        Pattern p = GlobHelper.translate(pattern, ".");
        this.skeletonPattern = null;
        if (this.skeletonBuilder == null) {
            this.skeletonBuilder = new StringBuilder();
        } else {
            this.skeletonBuilder.append("|");
        }
        this.skeletonBuilder.append("(").append(p.pattern()).append(")");
    }

    public void tip(String pattern) {
        Pattern p = GlobHelper.translate(pattern, ".");
        this.tipPattern = null;
        if (this.tipBuilder == null) {
            this.tipBuilder = new StringBuilder();
        } else {
            this.tipBuilder.append("|");
        }
        this.tipBuilder.append("(").append(p.pattern()).append(")");
    }

    public void feed(StackTraceElement[] trace) {
        this.ensureConfigured();
        StackTraceElement[] rtrace = trace;
        if (this.tipPattern != null) {
            rtrace = this.trimTips(rtrace);
        }
        if (this.classLumpPattern != null) {
            rtrace = this.lumpClasses(rtrace);
        }
        if (this.skeletonPattern != null) {
            rtrace = this.strip(rtrace);
        }
        if (this.maskPattern != null) {
            rtrace = this.mask(rtrace);
        }
        if (this.trimLineNumbers) {
            rtrace = this.trimNumbers(rtrace);
        }
        rtrace = this.trim(rtrace, this.maxDepth);
        this.append(this.root, rtrace, rtrace.length);
    }

    private void ensureConfigured() {
        if (this.maskBuilder != null && this.maskPattern == null) {
            this.maskPattern = Pattern.compile(this.maskBuilder.toString());
        }
        if (this.skeletonBuilder != null && this.skeletonPattern == null) {
            this.skeletonPattern = Pattern.compile(this.skeletonBuilder.toString());
        }
        if (this.tipBuilder != null && this.tipPattern == null) {
            this.tipPattern = Pattern.compile(this.tipBuilder.toString());
        }
        if (this.classLumpBuilder != null && this.classLumpPattern == null) {
            this.classLumpPattern = Pattern.compile(this.classLumpBuilder.toString());
        }
    }

    private StackTraceElement[] trim(StackTraceElement[] rtrace, int maxDepth) {
        if (rtrace.length <= maxDepth) {
            return rtrace;
        }
        return Arrays.copyOfRange(rtrace, rtrace.length - maxDepth, rtrace.length);
    }

    private StackTraceElement[] mask(StackTraceElement[] rtrace) {
        ArrayList<StackTraceElement> ftrace = new ArrayList<StackTraceElement>();
        boolean masked = false;
        for (StackTraceElement e : rtrace) {
            String frame = this.toShortFrame(e);
            Matcher m4 = this.maskPattern.matcher(frame);
            if (m4.matches()) {
                if (masked) continue;
                ftrace.add(STUB);
                masked = true;
                continue;
            }
            ftrace.add(e);
            masked = false;
        }
        return ftrace.toArray(new StackTraceElement[ftrace.size()]);
    }

    private StackTraceElement[] lumpClasses(StackTraceElement[] rtrace) {
        ArrayList<StackTraceElement> ftrace = new ArrayList<StackTraceElement>();
        for (StackTraceElement e : rtrace) {
            StackTraceElement prev;
            String cn = e.getClassName();
            Matcher m4 = this.classLumpPattern.matcher(cn);
            if (ftrace.size() > 0 && m4.matches() && cn.equals((prev = (StackTraceElement)ftrace.get(ftrace.size() - 1)).getClassName())) {
                ftrace.remove(ftrace.size() - 1);
            }
            ftrace.add(e);
        }
        return ftrace.toArray(new StackTraceElement[ftrace.size()]);
    }

    private StackTraceElement[] strip(StackTraceElement[] rtrace) {
        ArrayList<StackTraceElement> ftrace = new ArrayList<StackTraceElement>();
        boolean matched = false;
        for (StackTraceElement e : rtrace) {
            String frame = this.toShortFrame(e);
            Matcher m4 = this.skeletonPattern.matcher(frame);
            if (m4.matches()) {
                matched = true;
                ftrace.add(e);
                continue;
            }
            if (!this.showSkeletonTails || matched) continue;
            ftrace.add(e);
        }
        return ftrace.toArray(new StackTraceElement[ftrace.size()]);
    }

    private StackTraceElement[] trimTips(StackTraceElement[] rtrace) {
        ArrayList<StackTraceElement> ftrace = new ArrayList<StackTraceElement>();
        boolean matched = false;
        for (StackTraceElement e : rtrace) {
            String frame = this.toShortFrame(e);
            Matcher m4 = this.tipPattern.matcher(frame);
            if (!matched && m4.matches()) {
                matched = true;
                ftrace.clear();
                ftrace.add(e);
                continue;
            }
            ftrace.add(e);
        }
        return ftrace.toArray(new StackTraceElement[ftrace.size()]);
    }

    private StackTraceElement[] trimNumbers(StackTraceElement[] rtrace) {
        return rtrace;
    }

    public TextTree getTree() {
        return this.asTree(this.root);
    }

    private TextTree asTree(Node node) {
        if (this.compressedTree && node.children.size() == 1) {
            TextTree[] c;
            Node nnode = node;
            int n = 0;
            while (nnode.children.size() == 1) {
                Node nn;
                nnode = nn = nnode.children.values().iterator().next();
                ++n;
            }
            if (nnode.children.isEmpty()) {
                c = new TextTree[2];
            } else {
                c = new TextTree[3];
                c[2] = this.asTree(nnode);
            }
            c[0] = TextTree.t("skip " + n + (n == 1 ? " frame" : "frames"), new TextTree[0]);
            c[1] = TextTree.t("[" + nnode.hitCount + "] " + this.toString(nnode.element), new TextTree[0]);
            return TextTree.t("", c);
        }
        ArrayList<Node> children = new ArrayList<Node>();
        children.addAll(node.children.values());
        Collections.sort(children, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o2.hitCount - o1.hitCount;
            }
        });
        ArrayList<TextTree> tt = new ArrayList<TextTree>();
        for (Node n : children) {
            TextTree[] ttt;
            double p = 1.0 * (double)n.hitCount / (double)node.hitCount;
            double pa = 1.0 * (double)n.hitCount / (double)this.root.hitCount;
            if (p < this.branchVisibilityRelativeThreshold || pa < this.branchVisibilityAbsoluteThreshold) continue;
            String rate = String.format("%.1f%% (%.1f%%)", 100.0 * p, 100.0 * pa);
            if (n.children.isEmpty()) {
                ttt = new TextTree[1];
            } else {
                ttt = new TextTree[2];
                ttt[1] = this.asTree(n);
            }
            ttt[0] = TextTree.t(rate, TextTree.t("[" + n.hitCount + "] " + this.toString(n.element), new TextTree[0]));
            tt.add(TextTree.t("", ttt));
        }
        return new TextTree("", tt.toArray(new TextTree[tt.size()]));
    }

    private void append(Node node, StackTraceElement[] trace, int pos) {
        ++node.hitCount;
        if (pos != 0) {
            StackTraceElement e = trace[pos - 1];
            Node c = node.children.get(e);
            if (c == null) {
                c = new Node();
                c.element = e;
                c.parent = node;
                node.children.put(e, c);
            }
            this.append(c, trace, pos - 1);
        }
    }

    private String toString(StackTraceElement ste) {
        if (ste == STUB) {
            return "[...]";
        }
        if (ste.isNativeMethod() || ste.getLineNumber() < 0) {
            return this.toShortFrame(ste);
        }
        return ste.toString();
    }

    private String toShortFrame(StackTraceElement ste) {
        return ste.getClassName() + "." + ste.getMethodName();
    }

    private static class Node {
        Node parent;
        StackTraceElement element;
        int hitCount;
        Map<StackTraceElement, Node> children = new HashMap<StackTraceElement, Node>();

        private Node() {
        }
    }
}

