/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics;

import org.gridkit.jvmtool.stacktrace.analytics.AllocAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.CountAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.CpuAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.FilterAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.FrequencyAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.FrequencyHMAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.MaxTimestampAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.MinTimestampAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.NativeAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.PeriodCHMAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.SysCpuAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadDumpAggregator;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadIdAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadNameAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadStateAggregatorFactory;
import org.gridkit.jvmtool.stacktrace.analytics.WaitCallsAggregatorFactory;

public interface ThreadDumpAggregatorFactory {
    public static final CommonFactory COMMON = new CommonFactory();

    public ThreadDumpAggregator newInstance();

    public static class CommonFactory {
        public ThreadDumpAggregatorFactory maxTimestamp() {
            return new MaxTimestampAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory minTimestamp() {
            return new MinTimestampAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory count() {
            return new CountAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory cpu() {
            return new CpuAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory sysCpu() {
            return new SysCpuAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory alloc() {
            return new AllocAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory threadState(Thread.State state) {
            return new ThreadStateAggregatorFactory(state);
        }

        public ThreadDumpAggregatorFactory threadFilter(ThreadSnapshotFilter filter) {
            return new FilterAggregatorFactory(filter);
        }

        public ThreadDumpAggregatorFactory waitCalls() {
            return new WaitCallsAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory inNative() {
            return new NativeAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory frequency() {
            return new FrequencyAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory periodCHM() {
            return new PeriodCHMAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory frequencyHM() {
            return new FrequencyHMAggregatorFactory();
        }

        public ThreadDumpAggregatorFactory name() {
            return new ThreadNameAggregatorFactory(32);
        }

        public ThreadDumpAggregatorFactory name(int length) {
            return new ThreadNameAggregatorFactory(length);
        }

        public ThreadDumpAggregatorFactory threadId() {
            return new ThreadIdAggregatorFactory();
        }
    }
}

